/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.MobClasses;

import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import rpgclasses.data.MobData;

public class MobClassBuff
extends Buff {
    public MobClassBuff() {
        this.canCancel = false;
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
        int level = MobClassBuff.getMobLevel(activeBuff);
        activeBuff.addModifier(BuffModifiers.COMBAT_HEALTH_REGEN_FLAT, (Object)Float.valueOf(this.healthRegenBoost() * (float)activeBuff.owner.getMaxHealth()));
        activeBuff.setModifier(BuffModifiers.ALL_DAMAGE, (Object)Float.valueOf(this.damageBoost() + (float)MobData.levelScaling(level) * (1.0f + this.damageBoost()) * 0.02f));
        activeBuff.setModifier(BuffModifiers.SPEED, (Object)Float.valueOf(this.speedBoost() + (float)MobData.levelScaling(level) * (1.0f + this.speedBoost()) * 0.002f));
    }

    public float healthBoost() {
        return 0.0f;
    }

    public float healthRegenBoost() {
        return 0.01f;
    }

    public float damageBoost() {
        return 0.0f;
    }

    public float speedBoost() {
        return 0.0f;
    }

    public static void setMobLevel(ActiveBuff activeBuff, int level) {
        activeBuff.getGndData().setInt("moblevel", level);
    }

    public static int getMobLevel(ActiveBuff activeBuff) {
        return activeBuff.getGndData().getInt("moblevel", 0);
    }

    public void onRemoved(ActiveBuff activeBuff) {
        activeBuff.owner.buffManager.addBuff(new ActiveBuff(this.getStringID(), activeBuff.owner, 3600.0f, null), false);
    }
}

