/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.MobClasses;

import aphorea.utils.area.AphArea;
import aphorea.utils.area.AphAreaList;
import aphorea.utils.magichealing.AphMagicHealing;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import rpgclasses.buffs.MobClasses.MobClassBuff;
import rpgclasses.data.MobData;
import rpgclasses.utils.RPGUtils;

public class HealerMobClassBuff
extends MobClassBuff {
    public Map<Mob, Long> cooldowns = new HashMap<Mob, Long>();

    @Override
    public float healthBoost() {
        return 0.2f;
    }

    @Override
    public float healthRegenBoost() {
        return 0.02f;
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        Mob owner = activeBuff.owner;
        MobData mobData = MobData.getMob(owner);
        if (mobData != null && owner.isVisible()) {
            long lastArea = this.cooldowns.getOrDefault(owner, 0L);
            long now = owner.getTime();
            float cooldown = this.getCooldown();
            if (GameRandom.globalRandom.getChance(Math.min(cooldown, (float)(now - lastArea) / cooldown))) {
                owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(0, 255, 0)).height(16.0f);
            }
        }
    }

    public void serverTick(ActiveBuff activeBuff) {
        Mob owner = activeBuff.owner;
        MobData mobData = MobData.getMob(owner);
        if (mobData != null) {
            long cooldown;
            long lastArea = this.cooldowns.getOrDefault(owner, 0L);
            long now = owner.getTime();
            if (now - lastArea > (cooldown = this.getCooldown())) {
                int range = 300;
                if (owner.getHealthPercent() < 1.0f || RPGUtils.streamMobs(owner, range).anyMatch(t -> AphMagicHealing.canHealMob((Mob)owner, (Mob)t) && t.getHealthPercent() < 1.0f)) {
                    int heal = mobData.levelScaling() * 5;
                    AphAreaList areaList = new AphAreaList(new AphArea[]{new AphArea((float)range, new Color[]{new Color(0, 255, 0, 102)}).setHealingArea(heal)}).setOnlyVision(false);
                    areaList.execute(owner, true);
                }
                this.cooldowns.put(owner, now);
            }
        }
    }

    public long getCooldown() {
        return 6000L;
    }
}

