/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs.MobClasses;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import rpgclasses.buffs.MobClasses.MobClassBuff;
import rpgclasses.data.MobData;
import rpgclasses.levelevents.FireExplosionLevelEvent;

public class ExplosiveMobClassBuff
extends MobClassBuff {
    public Map<Mob, Long> cooldowns = new HashMap<Mob, Long>();

    @Override
    public float damageBoost() {
        return 0.1f;
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        Mob owner = activeBuff.owner;
        MobData mobData = MobData.getMob(owner);
        if (mobData != null && owner.isVisible()) {
            long cooldown;
            long lastExplosion = this.cooldowns.getOrDefault(owner, 0L);
            long now = owner.getTime();
            if (now - lastExplosion > (cooldown = this.getCooldown())) {
                owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(255, 0, 0)).height(16.0f);
            }
        }
    }

    public void onWasHit(ActiveBuff activeBuff, MobWasHitEvent event) {
        Mob owner = activeBuff.owner;
        MobData mobData = MobData.getMob(owner);
        if (mobData != null) {
            long cooldown;
            long lastExplosion = this.cooldowns.getOrDefault(owner, 0L);
            long now = owner.getTime();
            if (now - lastExplosion > (cooldown = this.getCooldown())) {
                int range = 200;
                GameDamage damage = new GameDamage((float)mobData.levelScaling());
                owner.getLevel().entityManager.events.add((LevelEvent)new FireExplosionLevelEvent(owner.x, owner.y, range, damage, owner, false, true));
                this.cooldowns.put(owner, now);
            }
        }
    }

    public long getCooldown() {
        return 6000L;
    }
}

