/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs;

import java.awt.Color;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.registry.RPGBuffs;

public class MagicPoisonBuff
extends Buff {
    public MagicPoisonBuff() {
        this.shouldSave = false;
        this.isImportant = true;
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        Mob owner = activeBuff.owner;
        if (owner.isVisible() && GameRandom.globalRandom.nextInt(2) == 0) {
            owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(150, 0, 150)).height(16.0f);
        }
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        MagicPoisonBuff.updateModifier(activeBuff);
    }

    public static void apply(Mob attacker, Mob target, float damage, float duration) {
        MagicPoisonBuff.apply(attacker, target, damage, (int)(duration * 1000.0f));
    }

    public static void apply(Mob attacker, Mob target, float damage, int duration) {
        PlayerData playerData;
        ActiveBuff ab = new ActiveBuff(RPGBuffs.MAGIC_POISON, target, duration, (Attacker)attacker);
        MagicPoisonBuff.setPoisonDamage(ab, damage);
        if (attacker.isPlayer && (playerData = PlayerDataList.getPlayerData((PlayerMob)attacker)).hasMasterySkill(Mastery.PYROMANCER)) {
            duration *= 2;
        }
        if (MagicPoisonBuff.shouldApply(target, damage, duration)) {
            target.buffManager.addBuff(ab, attacker.isServer());
        }
    }

    public static boolean shouldApply(Mob target, float damage, int duration) {
        if (!target.buffManager.hasBuff(RPGBuffs.MAGIC_POISON)) {
            return true;
        }
        float finalDamage = damage * (float)duration / 1000.0f;
        ActiveBuff ab = target.buffManager.getBuff(RPGBuffs.MAGIC_POISON);
        float finalOldDamage = ab.getGndData().getFloat("poisonDamage") * (float)ab.getDurationLeft() / 1000.0f;
        return finalDamage > finalOldDamage;
    }

    public static float getPoisonDamage(ActiveBuff activeBuff) {
        return activeBuff.getGndData().getFloat("poisonDamage");
    }

    public static void setPoisonDamage(ActiveBuff activeBuff, float damage) {
        activeBuff.getGndData().setFloat("poisonDamage", damage);
    }

    public static void updateModifier(ActiveBuff activeBuff) {
        activeBuff.setModifier(BuffModifiers.POISON_DAMAGE_FLAT, (Object)Float.valueOf(activeBuff.getGndData().getFloat("poisonDamage")));
    }
}

