/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs;

import necesse.engine.network.Packet;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ParticleOption;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.data.PlayerData;
import rpgclasses.data.PlayerDataList;
import rpgclasses.packets.PacketMobUpdateIgniteBuff;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGModifiers;

public class IgnitedBuff
extends Buff {
    public IgnitedBuff() {
        this.shouldSave = false;
        this.isImportant = true;
    }

    public void clientTick(ActiveBuff activeBuff) {
        if (activeBuff.owner.isVisible()) {
            Mob owner = activeBuff.owner;
            ParticleOption particle = owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).givesLight(0.0f, 0.5f).height(16.0f);
            if (this.isPurple(activeBuff)) {
                particle.color(ParticleOption.randomFlameColor((float)260.0f));
            } else {
                particle.flameColor();
            }
        }
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        activeBuff.setModifier(BuffModifiers.FIRE_DAMAGE_FLAT, (Object)Float.valueOf(activeBuff.getGndData().getFloat("igniteDamage")));
    }

    public boolean isPurple(ActiveBuff activeBuff) {
        return activeBuff.getGndData().getBoolean("isPurple");
    }

    public static void apply(Mob attacker, Mob target, float damage, float duration, boolean isPurple) {
        IgnitedBuff.apply(attacker, target, damage, (int)(duration * 1000.0f), isPurple);
    }

    public static void apply(Mob attacker, Mob target, float damage, int duration, boolean isPurple) {
        if (attacker.isServer()) {
            PlayerData playerData;
            ActiveBuff oldAB;
            ActiveBuff ab = new ActiveBuff(RPGBuffs.IGNITED, target, duration, (Attacker)attacker);
            if (isPurple) {
                ab.getGndData().setBoolean("isPurple", true);
            }
            boolean canApply = true;
            if (attacker.isPlayer && (oldAB = target.buffManager.getBuff(RPGBuffs.IGNITED)) != null && (playerData = PlayerDataList.getPlayerData((PlayerMob)attacker)).hasMasterySkill(Mastery.PYROMANCER)) {
                int durationLeft = oldAB.getDurationLeft();
                damage = oldAB.getGndData().getFloat("igniteDamage") * (float)durationLeft + damage * (float)duration;
                duration = durationLeft < duration ? (durationLeft + duration) / 2 : durationLeft;
                oldAB.getGndData().setFloat("igniteDamage", damage /= (float)duration);
                oldAB.setModifier(BuffModifiers.FIRE_DAMAGE_FLAT, (Object)Float.valueOf(damage));
                oldAB.setDurationLeft(duration);
                target.getServer().network.sendToClientsAtEntireLevel((Packet)new PacketMobUpdateIgniteBuff(target.getUniqueID(), oldAB), target.getLevel());
                canApply = false;
            }
            IgnitedBuff.setIgniteDamage(ab, damage);
            if (canApply && IgnitedBuff.shouldApply(target, damage, duration)) {
                target.buffManager.addBuff(ab, attacker.isServer(), true);
            }
        }
    }

    public static boolean shouldApply(Mob target, float damage, int duration) {
        if (!target.buffManager.hasBuff(RPGBuffs.IGNITED)) {
            return true;
        }
        float finalDamage = damage * (float)duration / 1000.0f;
        ActiveBuff ab = target.buffManager.getBuff(RPGBuffs.IGNITED);
        float finalOldDamage = ab.getGndData().getFloat("igniteDamage") * (float)ab.getDurationLeft() / 1000.0f;
        return finalDamage > finalOldDamage;
    }

    public static void setIgniteDamage(ActiveBuff activeBuff, float damage) {
        Mob attacker;
        Mob mob = attacker = activeBuff.getAttacker() == null ? null : activeBuff.getAttacker().getAttackOwner();
        if (attacker != null) {
            damage *= ((Float)attacker.buffManager.getModifier(RPGModifiers.IGNITE_DAMAGE)).floatValue();
        }
        activeBuff.getGndData().setFloat("igniteDamage", damage);
    }
}

