/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses.buffs;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicReference;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;

public class DarkCurseBuff
extends Buff {
    public DarkCurseBuff() {
        this.isVisible = true;
        this.isImportant = true;
        this.canCancel = false;
        this.shouldSave = true;
    }

    public void init(ActiveBuff activeBuff, BuffEventSubscriber eventSubscriber) {
        activeBuff.addModifier(BuffModifiers.INCOMING_DAMAGE_MOD, (Object)Float.valueOf(1.25f));
    }

    public void serverTick(ActiveBuff activeBuff) {
        this.tick(activeBuff);
    }

    public void clientTick(ActiveBuff activeBuff) {
        super.clientTick(activeBuff);
        this.tick(activeBuff);
        Mob owner = activeBuff.owner;
        GameRandom random = GameRandom.globalRandom;
        AtomicReference<Float> currentAngle = new AtomicReference<Float>(Float.valueOf(random.nextFloat() * 360.0f));
        float distance = 75.0f;
        for (int i = 0; i < 4; ++i) {
            owner.getLevel().entityManager.addParticle(owner.x + GameMath.sin((float)currentAngle.get().floatValue()) * distance + (float)random.getIntBetween(-5, 5), owner.y + GameMath.cos((float)currentAngle.get().floatValue()) * distance + (float)random.getIntBetween(-5, 5) * 0.85f, Particle.GType.CRITICAL).sprite(GameResources.puffParticles.sprite(random.getIntBetween(0, 4), 0, 12)).height(0.0f).moves((pos, delta, lifeTime, timeAlive, lifePercent) -> {
                float angle = currentAngle.accumulateAndGet(Float.valueOf(delta * 30.0f / 250.0f), Float::sum).floatValue();
                float distY = (distance - 20.0f) * 0.85f;
                pos.x = owner.x + GameMath.sin((float)angle) * (distance - distance / 2.0f * lifePercent);
                pos.y = owner.y + GameMath.cos((float)angle) * distY - 20.0f * lifePercent;
            }).color((options, lifeTime, timeAlive, lifePercent) -> {
                options.color(new Color(0, 0, 0));
                if (lifePercent > 0.5f) {
                    options.alpha(2.0f * (1.0f - lifePercent));
                }
            }).size((options, lifeTime, timeAlive, lifePercent) -> options.size(22, 22)).lifeTime(1000);
        }
    }

    public void tick(ActiveBuff activeBuff) {
        if (activeBuff.owner.getMaxHealth() > activeBuff.owner.getHealth()) {
            activeBuff.addModifier(BuffModifiers.MAX_HEALTH_FLAT, (Object)((int)Math.ceil((float)(activeBuff.owner.getHealth() - activeBuff.owner.getMaxHealth()) / ((Float)activeBuff.owner.buffManager.getModifier(BuffModifiers.MAX_HEALTH)).floatValue())));
        }
    }

    public ListGameTooltips getTooltip(ActiveBuff ab, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltip(ab, blackboard);
        tooltips.add(Localization.translate((String)"buffdesc", (String)"darkcursebuff1"));
        tooltips.add(Localization.translate((String)"buffdesc", (String)"darkcursebuff2"));
        return tooltips;
    }
}

