/*
 * Decompiled with CFR 0.152.
 */
package rpgclasses;

import necesse.engine.modLoader.ModSettings;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.TileRegistry;
import necesse.level.gameTile.GameTile;
import rpgclasses.RPGResources;
import rpgclasses.content.MobClass;
import rpgclasses.content.player.Attribute;
import rpgclasses.content.player.Mastery.Mastery;
import rpgclasses.content.player.PlayerClass;
import rpgclasses.content.player.SkillsLogic.ComplexExtraToolTip;
import rpgclasses.content.player.SkillsLogic.Passives.SimpleBuffPassive;
import rpgclasses.content.player.SkillsLogic.Skill;
import rpgclasses.registry.RPGBuffs;
import rpgclasses.registry.RPGCommands;
import rpgclasses.registry.RPGContainers;
import rpgclasses.registry.RPGControls;
import rpgclasses.registry.RPGDamageType;
import rpgclasses.registry.RPGEnchantments;
import rpgclasses.registry.RPGItems;
import rpgclasses.registry.RPGLevelEvents;
import rpgclasses.registry.RPGLootTables;
import rpgclasses.registry.RPGMobs;
import rpgclasses.registry.RPGModifiers;
import rpgclasses.registry.RPGPackets;
import rpgclasses.registry.RPGProjectiles;
import rpgclasses.registry.RPGRecipes;
import rpgclasses.registry.RPGTiles;
import rpgclasses.settings.RPGSettings;

@ModEntry
public class RPGMod {
    public static String currentVersion = "v0.7.17";

    public void preInit() {
    }

    public void init() {
        MobClass.registerCore();
        Attribute.registerCore();
        Mastery.registerCore();
        Mastery.masterySkillsList.forEach(SimpleBuffPassive::registry);
        ComplexExtraToolTip.registerCore();
        PlayerClass.registerCore();
        PlayerClass.classesList.forEach(playerClass -> playerClass.passivesList.each(Skill::registry));
        PlayerClass.classesList.forEach(playerClass -> playerClass.activeSkillsList.each(Skill::registry));
        RPGContainers.registerCore();
        RPGControls.registerCore();
        RPGPackets.registerCore();
        RPGCommands.registerCore();
        RPGLevelEvents.registerCore();
        RPGDamageType.registerCore();
        RPGItems.registerCore();
        RPGBuffs.registerCore();
        RPGMobs.registerCore();
        RPGProjectiles.registerCore();
        RPGEnchantments.registerCore();
    }

    public void postInit() {
        RPGLootTables.modifyLootTables();
        RPGRecipes.initRecipes();
        for (GameTile tile : TileRegistry.getTiles()) {
            String tileStringID = tile.getStringID();
            if (!tileStringID.contains("grass")) continue;
            RPGTiles.grassTiles.add(tileStringID);
        }
    }

    public void initResources() {
        RPGResources.initResources();
    }

    public ModSettings initSettings() {
        return RPGSettings.init();
    }

    static {
        new RPGModifiers();
    }
}

