/*
 * Decompiled with CFR 0.152.
 */
package NPCShopsExpanded;

import NPCShopsExpanded.ClearRegistry;
import necesse.engine.modLoader.annotations.ModConstructorPatch;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.humanShop.BuyingShopItem;
import necesse.entity.mobs.friendly.human.humanShop.HumanShop;
import necesse.entity.mobs.friendly.human.humanShop.MageHumanMob;
import necesse.entity.mobs.friendly.human.humanShop.SellingShopItem;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.placeableItem.objectItem.WaystoneObjectItem;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import net.bytebuddy.asm.Advice;

@ModConstructorPatch(target=MageHumanMob.class, arguments={})
public class MageShopPatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This MageHumanMob Mob) {
        ClearRegistry.Clear(Mob.shop.sellingShop);
        Mob.shop.addSellingItem("voidpouch", new SellingShopItem()).setStaticPriceBasedOnHappiness(750, 1000, 50);
        Mob.shop.addSellingItem("voidbag", new SellingShopItem()).setStaticPriceBasedOnHappiness(2500, 3000, 100);
        Mob.shop.addSellingItem("homestone", new SellingShopItem()).setItem(MageShopPatch::GenerateHomestone).setStaticPriceBasedOnHappiness(1000, 1250, 100);
        Mob.shop.addSellingItem("waystone", new SellingShopItem()).setItem(MageShopPatch::GenerateWaystone).setStaticPriceBasedOnHappiness(250, 500, 100);
        Mob.shop.addSellingItem("recallscroll", new SellingShopItem()).setStaticPriceBasedOnHappiness(25, 50, 5);
        Mob.shop.addSellingItem("teleportationscroll", new SellingShopItem()).setStaticPriceBasedOnHappiness(50, 75, 5);
        Mob.shop.addSellingItem("bloodbolt", new SellingShopItem()).setStaticPriceBasedOnHappiness(60, 75, 5);
        Mob.shop.addSellingItem("voidstaff", new SellingShopItem()).setStaticPriceBasedOnHappiness(400, 600, 10).addKilledMobRequirement("evilsprotector");
        Mob.shop.addSellingItem("shadowbeam", new SellingShopItem()).setStaticPriceBasedOnHappiness(800, 900, 25).addKilledMobRequirement("reaper");
        Mob.shop.addSellingItem("venomshower", new SellingShopItem()).setStaticPriceBasedOnHappiness(1200, 1500, 50).addKilledMobRequirement("sageandgrit");
        Mob.shop.addSellingItem("manapotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(10, 25, 5);
        Mob.shop.addSellingItem("greatermanapotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(40, 50, 5).addKilledMobRequirement("piratecaptain");
        Mob.shop.addSellingItem("superiormanapotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(80, 100, 5).addKilledMobRequirement("fallenwizard");
        Mob.shop.addSellingItem("manaregenpotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(10, 25, 5);
        Mob.shop.addSellingItem("greatermanaregenpotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(50, 100, 5).addKilledMobRequirement("fallenwizard");
        Mob.shop.addSellingItem("wisdompotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(25, 50, 5).addKilledMobRequirement("piratecaptain");
        Mob.shop.addSellingItem("minionpotion", new SellingShopItem()).setStaticPriceBasedOnHappiness(25, 50, 5).addKilledMobRequirement("piratecaptain");
        Mob.shop.addSellingItem("magicmanual", new SellingShopItem()).setStaticPriceBasedOnHappiness(300, 400, 10).addKilledMobRequirement("evilsprotector");
        Mob.shop.addBuyingItem("book", new BuyingShopItem()).setPriceBasedOnHappiness(30, 15, 5);
    }

    public static InventoryItem GenerateHomestone(GameRandom random, ServerClient client, HumanShop mob) {
        ServerSettlementData Settlement = mob.getSettlerSettlementServerData();
        return Settlement != null ? new InventoryItem("homestone") : null;
    }

    public static InventoryItem GenerateWaystone(GameRandom random, ServerClient client, HumanShop mob) {
        ServerSettlementData Settlement = mob.getSettlerSettlementServerData();
        return Settlement != null ? WaystoneObjectItem.setupWaystoneItem((InventoryItem)new InventoryItem("waystone"), (int)mob.getSettlementUniqueID()) : null;
    }
}

