/*
 * Decompiled with CFR 0.152.
 */
package whatisthat.finders;

import necesse.engine.modLoader.LoadedMod;
import necesse.engine.registries.ItemRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.WormMobBody;
import necesse.level.gameObject.GameObject;
import necesse.level.gameTile.GameTile;
import whatisthat.container.Settings;
import whatisthat.data.VanillaMobs;

public class ModFinder {
    public static String getMod(Object input) {
        try {
            if (input instanceof Mob) {
                return ModFinder.getMobMod((Mob)input);
            }
            if (input instanceof GameObject) {
                return ModFinder.getObjectMod((GameObject)input);
            }
            if (input instanceof GameTile) {
                return ModFinder.getTileMod((GameTile)input);
            }
            return "???";
        }
        catch (Exception e) {
            if (Settings.extra_debug_logs) {
                System.err.println("Error while processing mod: " + e);
            }
            return "ERROR";
        }
    }

    public static String getMobMod(Mob mob) {
        String mobID = mob.getStringID();
        if (mob instanceof WormMobBody) {
            if (mobID.contains("body")) {
                return VanillaMobs.isVanillaOrMod(mob.getStringID().replace("body", ""));
            }
            if (mobID.contains("tail")) {
                return VanillaMobs.isVanillaOrMod(mob.getStringID().replace("tail", ""));
            }
        }
        return VanillaMobs.isVanillaOrMod(mob.getStringID());
    }

    public static String getObjectMod(GameObject object) {
        int item = ItemRegistry.getItemID((String)object.getStringID());
        LoadedMod mod = ItemRegistry.getItemMod((int)item);
        return mod != null ? mod.name : "Vanilla";
    }

    public static String getTileMod(GameTile tile) {
        int item = ItemRegistry.getItemID((String)tile.getStringID());
        LoadedMod mod = ItemRegistry.getItemMod((int)item);
        return mod != null ? mod.name : "Vanilla";
    }
}

