/*
 * Decompiled with CFR 0.152.
 */
package whatisthat.finders;

import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.WormMobBody;
import necesse.level.gameObject.GameObject;
import necesse.level.gameTile.GameTile;
import whatisthat.HelperClasses.TypeUtility;
import whatisthat.container.Settings;

public class LangFinder {
    private static final GameMessage localizationNotFound = new StaticMessage("N/A");

    public static GameMessage getLocalization(Object input) {
        try {
            if (input instanceof Mob) {
                return LangFinder.getMobLocalization((Mob)input);
            }
            if (input instanceof GameObject) {
                return LangFinder.getObjectLocalization((GameObject)input);
            }
            if (input instanceof GameTile) {
                return LangFinder.getTileLocalization((GameTile)input);
            }
            return LocalMessage.getNewMessage((String)"unknown");
        }
        catch (Exception e) {
            if (Settings.extra_debug_logs) {
                System.err.println("Error while processing localization:\n" + e);
            }
            return LocalMessage.getNewMessage((String)"ERROR");
        }
    }

    public static GameMessage getMobLocalization(Mob mob) {
        GameMessage localization = mob.getLocalization();
        if (mob instanceof WormMobBody) {
            String wormMobStringID = TypeUtility.sanitizeWormMobID(mob.getStringID());
            localization = MobRegistry.getLocalization((String)wormMobStringID);
        }
        if (localization.isSame(localizationNotFound)) {
            return new StaticMessage("Unknown");
        }
        return localization;
    }

    public static GameMessage getObjectLocalization(GameObject object) {
        GameMessage localization = object.getLocalization();
        if (localization.isSame(localizationNotFound)) {
            return new StaticMessage("Unknown");
        }
        return localization;
    }

    public static GameMessage getTileLocalization(GameTile tile) {
        GameMessage localization = tile.getLocalization();
        if (localization.isSame(localizationNotFound)) {
            return new StaticMessage("Unknown");
        }
        return localization;
    }
}

