/*
 * Decompiled with CFR 0.152.
 */
package whatisthat.finders;

import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.WormMobBody;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.InventoryItem;
import necesse.level.gameObject.CustomWildFlowerObject;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.SeedObject;
import necesse.level.gameObject.furniture.FlowerObject;
import necesse.level.gameTile.GameTile;
import whatisthat.HelperClasses.TypeUtility;
import whatisthat.container.Settings;
import whatisthat.data.SpecialCasesList;

public class IconFinder {
    private static final GameTexture errorTexture = GameTexture.fromFile((String)"error");
    private static final SpecialCasesList specialCases = new SpecialCasesList();

    public static GameTexture getIcon(Object input, PlayerMob player) {
        try {
            if (input instanceof Mob) {
                return IconFinder.getMobIcon((Mob)input);
            }
            if (input instanceof GameObject) {
                return IconFinder.getObjectIcon((GameObject)input);
            }
            if (input instanceof GameTile) {
                return IconFinder.getTileIcon((GameTile)input, player);
            }
            return errorTexture;
        }
        catch (Exception e) {
            if (Settings.extra_debug_logs) {
                System.err.println("Error while processing icon: " + e);
            }
            return GameTexture.fromFile((String)"error");
        }
    }

    public static GameTexture getMobIcon(Mob mob) {
        String wormMobStringID;
        GameTexture icon = mob.getMobIcon();
        if (IconFinder.isNotErrorOrNull(icon)) {
            return icon;
        }
        if (IconFinder.specialCases.specialMobs.containsKey(mob.getStringID()) && IconFinder.isNotErrorOrNull(icon = GameTexture.fromFile((String)IconFinder.specialCases.specialMobs.get(mob.getStringID())))) {
            return icon;
        }
        if (mob instanceof WormMobBody && IconFinder.isNotErrorOrNull(icon = MobRegistry.getMobIcon((String)(wormMobStringID = TypeUtility.sanitizeWormMobID(mob.getStringID()))))) {
            return icon;
        }
        return errorTexture;
    }

    public static GameTexture getObjectIcon(GameObject object) {
        if (object instanceof SeedObject) {
            return ((SeedObject)object).texture;
        }
        if (object instanceof CustomWildFlowerObject) {
            return ((CustomWildFlowerObject)object).texture;
        }
        if (object instanceof FlowerObject) {
            return ((FlowerObject)object).itemTexture;
        }
        GameTexture texture = ObjectRegistry.getObject((String)object.getStringID()).generateItemTexture();
        if (IconFinder.isNotErrorOrNull(texture)) {
            return texture;
        }
        texture = ObjectRegistry.getObject((String)object.getStringID().replaceAll("\\d", "")).generateItemTexture();
        if (IconFinder.isNotErrorOrNull(texture)) {
            return texture;
        }
        return errorTexture;
    }

    public static GameTexture getTileIcon(GameTile tile, PlayerMob player) {
        String tileStringId = tile.getStringID().replaceAll("\\d", "");
        return tile.getTileItem().getItemSprite((InventoryItem)new InventoryItem((String)tileStringId), (PlayerMob)player).texture;
    }

    public static boolean isNotErrorOrNull(GameTexture icon) {
        return icon != null && !icon.equals(GameTexture.fromFile((String)"error"));
    }
}

