/*
 * Decompiled with CFR 0.152.
 */
package whatisthat.container;

import java.awt.Rectangle;
import java.util.ArrayList;
import necesse.engine.GlobalData;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.client.Client;
import necesse.engine.state.MainGame;
import necesse.engine.util.GameMath;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.Mob;
import necesse.gfx.camera.MainGameCamera;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormIcon;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameObject.SeedObject;
import necesse.level.maps.Level;
import whatisthat.HelperClasses.TypeUtility;
import whatisthat.container.Settings;
import whatisthat.finders.IconFinder;
import whatisthat.finders.LangFinder;
import whatisthat.finders.ModFinder;

public class DisplayBoxForm
extends Form
implements FormPositionContainer {
    private int counter = 0;
    private final ArrayList<Integer> dataHeight = new ArrayList();

    public DisplayBoxForm() {
        super(Settings.Width, 55);
        this.setDraggingBox(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.onDragged(e -> {
            GameWindow window = WindowManager.getWindow();
            e.x = GameMath.limit((int)e.x, (int)(-this.getWidth() + 20), (int)(window.getHudWidth() - 20));
            e.y = GameMath.limit((int)e.y, (int)(-this.getHeight() + 20), (int)(window.getHudHeight() - 20));
        });
        this.allowResize(true, true, true, true, e -> {});
    }

    public void updateContent() {
        try {
            if (!(GlobalData.getCurrentState() instanceof MainGame)) {
                return;
            }
            this.clearComponents();
            this.dataHeight.clear();
            MainGame mainGame = (MainGame)GlobalData.getCurrentState();
            Client client = mainGame.getClient();
            if (client == null) {
                return;
            }
            MainGameCamera gameCamera = mainGame.getCamera();
            int x = WindowManager.getWindow().mousePos().sceneX + gameCamera.getX();
            int y = WindowManager.getWindow().mousePos().sceneY + gameCamera.getY();
            Level level = client.getLevel();
            if (level == null) {
                return;
            }
            FormFlow yIcons = new FormFlow(10);
            Object obj = TypeUtility.getTarget(level, x, y);
            this.dataHeight.add(this.addIcon(5, 10, 32, 32, IconFinder.getIcon(obj, client.getPlayer())));
            this.addComponent((FormComponent)((FormLocalLabel)yIcons.nextY((FormPositionContainer)new FormLocalLabel(LangFinder.getLocalization(obj), new FontOptions(17), 45, 45, 0, this.getWidth() - 50), 0)));
            FormFlow yText = new FormFlow(yIcons.next());
            if (obj instanceof SeedObject) {
                this.dataHeight.add(this.addLabelNext(yText, 45, "Stage " + (((SeedObject)obj).thisStage + 1) + "/" + ((SeedObject)obj).stageIDs.length, 0));
            }
            if (obj instanceof Mob) {
                Mob mob = (Mob)obj;
                this.dataHeight.add(this.addIcon(yIcons, 45, 0, 12, 12, GameTexture.fromFile((String)"ui/primal/heart_fill"), 0));
                this.addLabelNext(yText, 58, mob.getHealth() + "/" + mob.getMaxHealth(), 0);
                if (mob.getArmor() != 0.0f) {
                    this.dataHeight.add(this.addIcon(yIcons, 45, 0, 12, 12, GameTexture.fromFile((String)"ui/primal/resilience_fill"), 0.2f, 0));
                    this.addLabelNext(yText, 58, Integer.toString((int)mob.getArmor()), 0);
                }
                if (mob.getResilience() != 0.0f) {
                    this.dataHeight.add(this.addIcon(yIcons, 45, 0, 12, 12, GameTexture.fromFile((String)"ui/primal/resilience_fill"), 0));
                    this.addLabelNext(yText, 58, (int)mob.getResilience() + "/" + mob.getMaxResilience(), 0);
                }
            }
            this.dataHeight.add(this.addLabelNext(yText, 45, ModFinder.getMod(obj), 0));
            this.setMinimumResize(10, 10);
            int h = 0;
            for (int value : this.dataHeight) {
                h += value;
            }
            this.setHeight(h);
            if (this.counter < 20) {
                ++this.counter;
            } else {
                this.counter = 0;
                if (this.getX() != Settings.X_origin_point) {
                    Settings.X_origin_point = this.getX();
                }
                if (this.getY() != Settings.Y_origin_point) {
                    Settings.Y_origin_point = this.getY();
                }
                if (this.getWidth() != Settings.Width) {
                    Settings.Width = this.getWidth();
                }
            }
        }
        catch (Exception e) {
            if (Settings.extra_debug_logs) {
                System.err.println("Something went wrong in the main form: " + e);
            }
            this.addComponent((FormComponent)new FormIcon(5, 10, 32, 32, GameTexture.fromFile((String)"error"), 1.0f));
            this.addComponent((FormComponent)new FormLocalLabel((GameMessage)new StaticMessage("ERROR"), new FontOptions(17), 45, 45, 0, this.getWidth() - 45));
            this.addComponent((FormComponent)new FormLabel("ERROR", new FontOptions(10), 45, 45, 0));
        }
    }

    public int addIcon(FormFlow yFlow, int x, int y, int width, int height, GameTexture texture, float gray, int yPlus) {
        return ((FormIcon)this.addComponent((FormComponent)((FormIcon)yFlow.nextY((FormPositionContainer)new FormIcon(x, y, width, height, texture, gray), yPlus)))).getHeight();
    }

    public int addIcon(FormFlow yFlow, int x, int y, int width, int height, GameTexture texture, int yPlus) {
        return ((FormIcon)this.addComponent((FormComponent)((FormIcon)yFlow.nextY((FormPositionContainer)new FormIcon(x, y, width, height, texture, 1.0f), yPlus)))).getHeight();
    }

    public int addIcon(int x, int y, int width, int height, GameTexture texture) {
        return ((FormIcon)this.addComponent((FormComponent)new FormIcon(x, y, width, height, texture, 1.0f))).getHeight();
    }

    public int addLabelNext(FormFlow yFlow, int x, String text, int yPlus) {
        return ((FormLabel)this.addComponent((FormComponent)((FormLabel)yFlow.nextY((FormPositionContainer)new FormLabel(text, new FontOptions(12), 45, x, 0), yPlus)))).getHeight();
    }
}

