/*
 * Decompiled with CFR 0.152.
 */
package whatisthat.HelperClasses;

import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.Mob;
import necesse.level.gameObject.GameObject;
import necesse.level.gameTile.GameTile;
import necesse.level.maps.Level;
import whatisthat.container.Settings;

public class TypeUtility {
    public static Object getTarget(Level level, int x, int y) {
        try {
            Mob mob = TypeUtility.getMob(level, x, y);
            if (mob != null) {
                return mob;
            }
            GameObject object = TypeUtility.getObject(level, x = GameMath.getTileCoordinate((int)x), y = GameMath.getTileCoordinate((int)y));
            if (object != null) {
                return object;
            }
            return TypeUtility.getTile(level, x, y);
        }
        catch (Exception e) {
            if (Settings.extra_debug_logs) {
                System.err.println("Error while getting the target: " + e);
            }
            return TileRegistry.getTile((int)TileRegistry.dirtID);
        }
    }

    public static String sanitizeWormMobID(String mobStringID) {
        if (mobStringID.contains("body")) {
            mobStringID = mobStringID.replace("body", "");
        } else if (mobStringID.contains("tail")) {
            mobStringID = mobStringID.replace("tail", "");
        }
        return mobStringID;
    }

    public static Mob getMob(Level level, int x, int y) {
        for (Mob mob : level.entityManager.mobs.getInRegionRangeByTile(x / 32, y / 32, 1)) {
            if (!mob.getSelectBox().contains(x, y)) continue;
            return mob;
        }
        return null;
    }

    public static GameObject getObject(Level level, int x, int y) {
        GameObject object = level.getObject(x, y);
        if (object != null && !object.getStringID().equals("air")) {
            return object;
        }
        return null;
    }

    public static GameTile getTile(Level level, int x, int y) {
        return level.getTile(x, y);
    }
}

