/*
 * Decompiled with CFR 0.152.
 */
package altariasmod.modclasses.Staffs.Magic;

import altariasmod.modclasses.Staffs.Magic.Projectiles.VoidShardStaffProjectile;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.presets.MagicWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;

public class VoidShardStaff
extends MagicProjectileToolItem {
    public VoidShardStaff() {
        super(1900, MagicWeaponsLootTable.magicWeapons);
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(600);
        this.attackDamage.setBaseValue(32.0f).setUpgradedValue(1.0f, 35.0f);
        this.velocity.setBaseValue(100);
        this.attackXOffset = 15;
        this.attackYOffset = 20;
        this.attackRange.setBaseValue(1250);
        this.knockback.setBaseValue(15);
        this.manaCost.setBaseValue(5.0f).setUpgradedValue(1.0f, 3.2f);
        this.resilienceGain.setBaseValue(0.5f);
        this.itemAttackerProjectileCanHitWidth = 5.0f;
        this.itemAttackerPredictionDistanceOffset = -20.0f;
        this.canBeUsedForRaids = true;
        this.minRaidTier = 1;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.3f).pitch(GameRandom.globalRandom.getFloatBetween(1.5f, 1.6f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        GameRandom random = new GameRandom((long)seed);
        for (int i = -1; i <= 1; ++i) {
            VoidShardStaffProjectile projectile = new VoidShardStaffProjectile(level, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), (Mob)attackerMob);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.resetUniqueID(random);
            attackerMob.addAndSendAttackerProjectile((Projectile)projectile, 20, (float)(10 * i));
        }
        this.consumeMana(attackerMob, item);
        return item;
    }
}

