/*
 * Decompiled with CFR 0.152.
 */
package NecQol;

import NecQol.Patches.SellingShopItemPatch;
import NecQol.Patches.ShopManagerPatch;
import NecQol.Patches.SwampDwellerStaffFlowerProjectilePatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import necesse.engine.GlobalData;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.entity.mobs.friendly.human.humanShop.SellingShopItem;
import necesse.entity.mobs.friendly.human.humanShop.ShopManager;
import necesse.entity.projectile.SwampDwellerStaffFlowerProjectile;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@ModEntry
public class ModMain {
    public static double shopStockMultiplier = 1.0;
    public static double shopRestockMultiplier = 10.0;
    public static int shopWealth = 8000;
    public static int shopWealthChangePerDay = 100;
    public static boolean restoreSwampDwellerStaffLogic = true;

    public void init() throws IOException, NumberFormatException {
        this.setValues();
    }

    public void initResources() {
    }

    public void preInit() {
        ByteBuddyAgent.install();
        new ByteBuddy().rebase(SellingShopItem.class).visit((AsmVisitorWrapper)Advice.to(SellingShopItemPatch.class).on((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{Integer.TYPE, Integer.TYPE})))).make().load(SellingShopItem.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        new ByteBuddy().rebase(ShopManager.class).visit((AsmVisitorWrapper)Advice.to(ShopManagerPatch.class).on((ElementMatcher)ElementMatchers.isConstructor())).make().load(ShopManager.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        new ByteBuddy().rebase(SwampDwellerStaffFlowerProjectile.class).visit((AsmVisitorWrapper)Advice.to(SwampDwellerStaffFlowerProjectilePatch.class).on((ElementMatcher)ElementMatchers.named((String)"init").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).make().load(SwampDwellerStaffFlowerProjectile.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    private void setValues() throws IOException {
        String filename = GlobalData.cfgPath() + "\\mods\\NecQol\\config.cfg";
        System.out.println("Config file for NecQol mod: " + filename);
        try {
            File file = new File(filename);
            if (!file.exists()) {
                Path parentDir = file.getParentFile().toPath();
                Files.createDirectories(parentDir, new FileAttribute[0]);
                if (!file.createNewFile()) {
                    throw new IOException("Error creating file: " + file.toPath());
                }
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    writer.write(Localization.translate((String)"config", (String)"necqolconfigtitle") + "\n" + Localization.translate((String)"config", (String)"necqolconfigdesc") + "\nShopStockMultiplier=1\nShopRestockMultiplier=10\nShopWealth=8000\nShopWealthChangePerDay=500\nRestoreSwampDwellerStaffLogic=true\n");
                }
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
                String line;
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.startsWith("#") || !line.contains("=") || (parts = line.split("=", 2)).length != 2) continue;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    try {
                        switch (key) {
                            case "ShopStockMultiplier": {
                                shopStockMultiplier = Double.parseDouble(value);
                                break;
                            }
                            case "ShopRestockMultiplier": {
                                shopRestockMultiplier = Double.parseDouble(value);
                                break;
                            }
                            case "ShopWealth": {
                                shopWealth = Integer.parseInt(value);
                                break;
                            }
                            case "ShopWealthChangePerDay": {
                                shopWealthChangePerDay = Integer.parseInt(value);
                                break;
                            }
                            case "RestoreSwampDwellerStaffLogic": {
                                restoreSwampDwellerStaffLogic = Boolean.parseBoolean(value);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println("\u65e0\u6cd5\u89e3\u6790\u914d\u7f6e\u503c: " + line + " - " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }
}

