/*
 * Decompiled with CFR 0.152.
 */
package archipelago.patches;

import java.util.ArrayList;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.inventory.recipe.Ingredient;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ToolItem.class, name="getUpgradedItem", arguments={InventoryItem.class})
public class WeaponUpgradeCostUpdate {
    @Advice.OnMethodExit
    static void onExit(@Advice.This ToolItem baseItem, @Advice.Argument(value=0) InventoryItem item, @Advice.Return(readOnly=false) UpgradedItem upgradedItem) {
        ArrayList<Ingredient> newCost = new ArrayList<Ingredient>();
        InventoryItem lastItem = upgradedItem.lastItem;
        InventoryItem uItem = upgradedItem.upgradedItem;
        Ingredient[] cost = upgradedItem.cost;
        int shardCost = cost[0].getIngredientAmount();
        int chunkCost = (int)Math.floor(shardCost / 100);
        int stoneCost = (int)Math.floor(shardCost / 300);
        int weaponStoneCost = (int)Math.floor(shardCost / 1000);
        newCost.add(new Ingredient("upgradeshard", shardCost - chunkCost * 50 - stoneCost * 100));
        if (chunkCost > 0) {
            newCost.add(new Ingredient("archipelago_upgradechunk", chunkCost));
            if (stoneCost > 0) {
                newCost.add(new Ingredient("archipelago_upgradestone", stoneCost));
                if (weaponStoneCost > 0) {
                    newCost.add(new Ingredient("archipelago_weaponstone", weaponStoneCost));
                }
            }
        }
        upgradedItem = new UpgradedItem(lastItem, uItem, newCost.toArray(cost));
    }
}

