/*
 * Decompiled with CFR 0.152.
 */
package archipelago.patches;

import java.util.ArrayList;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.armorItem.ArmorItem;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.inventory.recipe.Ingredient;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ArmorItem.class, name="getUpgradedItem", arguments={InventoryItem.class})
public class ArmorUpgradeCostUpdate {
    @Advice.OnMethodExit
    static void onExit(@Advice.This ArmorItem baseItem, @Advice.Argument(value=0) InventoryItem item, @Advice.Return(readOnly=false) UpgradedItem upgradedItem) {
        ArrayList<Ingredient> newCost = new ArrayList<Ingredient>();
        InventoryItem lastItem = upgradedItem.lastItem;
        InventoryItem uItem = upgradedItem.upgradedItem;
        Ingredient[] cost = upgradedItem.cost;
        int shardCost = cost[0].getIngredientAmount() * 2;
        int chunkCost = (int)Math.floor(shardCost / 100);
        int stoneCost = (int)Math.floor(shardCost / 300);
        int armorStoneCost = (int)Math.floor(shardCost / 1000);
        newCost.add(new Ingredient("upgradeshard", shardCost - chunkCost * 50 - stoneCost * 100));
        if (chunkCost > 0) {
            newCost.add(new Ingredient("archipelago_upgradechunk", chunkCost));
            if (stoneCost > 0) {
                newCost.add(new Ingredient("archipelago_upgradestone", stoneCost));
                if (armorStoneCost > 0) {
                    newCost.add(new Ingredient("archipelago_armorstone", armorStoneCost));
                }
            }
        }
        upgradedItem = new UpgradedItem(lastItem, uItem, newCost.toArray(cost));
    }
}

