/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Supplier;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobSpawnLocation;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.trees.CollisionPlayerChaserWandererAI;
import necesse.entity.mobs.hostile.HostileMob;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.light.GameLight;

public class WaterBiomeMobShark
extends HostileMob {
    public static GameTexture texture;
    public static LootTable lootTable;

    public WaterBiomeMobShark() {
        super(250);
        this.setArmor(10);
        this.setSpeed(0.1f);
        this.setFriction(3.0f);
        this.setSwimSpeed(300.0f);
        this.collision = new Rectangle(-10, -7, 14, 20);
        this.hitBox = new Rectangle(-14, -12, 24, 28);
        this.selectBox = new Rectangle(-14, -41, 48, 28);
        this.swimMaskMove = 10;
        this.swimMaskOffset = 4;
        this.swimSinkOffset = 4;
        this.setKnockbackModifier(0.25f);
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, (AINode)new CollisionPlayerChaserWandererAI((Supplier)null, 384, new GameDamage(35.0f), 25, 40000));
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public int getTileWanderPriority(TilePosition pos, Biome baseBiome) {
        if (pos.tileID() == TileRegistry.waterID) {
            return 1000;
        }
        return 0;
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        for (int i = 0; i < 4; ++i) {
            this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), texture, GameRandom.globalRandom.nextInt(5), 8, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 30;
        int drawY = camera.getDrawY(y) - 48;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        final MaskShaderOptions swimMask = this.getSwimMaskShaderOptions(this.inLiquidFloat(x, y));
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 64).addMaskShader(swimMask).light(light).pos(drawX, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
                swimMask.use();
                this.val$options.draw();
                swimMask.stop();
            }
        });
        TextureDrawOptionsEnd shadow = texture.initDraw().sprite(0, dir, 64).light(light).pos(drawX, drawY);
        tileList.add(arg_0 -> WaterBiomeMobShark.lambda$addDrawables$0((TextureDrawOptions)shadow, arg_0));
    }

    public int getRockSpeed() {
        return 8;
    }

    public MobSpawnLocation checkSpawnLocation(MobSpawnLocation location) {
        return location.checkNotLevelCollides().checkTile((tileX, tileY) -> {
            int tileID = this.getLevel().getTileID(tileX.intValue(), tileY.intValue());
            if (tileID == TileRegistry.waterID) {
                return true;
            }
            int height = this.getLevel().liquidManager.getHeight(tileX.intValue(), tileY.intValue());
            return height >= 0 && height <= 3;
        });
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadow, TickManager tm) {
        shadow.draw();
    }

    static {
        lootTable = new LootTable(new LootItemInterface[]{new ChanceLootItem(0.4f, "archipelago_sharkteeth", 1)});
    }
}

