/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.world.biomeGenerator.BiomeGeneratorStack;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.biomes.FishingLootTable;
import necesse.level.maps.biomes.FishingSpot;
import necesse.level.maps.biomes.MobSpawnTable;
import necesse.level.maps.presets.set.VillageSet;
import necesse.level.maps.regionSystem.Region;

public class WaterBiome
extends Biome {
    public static MobSpawnTable surfaceCritters = new MobSpawnTable().add(50, "archipelago_shark");
    public static MobSpawnTable caveCritters = new MobSpawnTable().add(100, "stonecaveling");
    public static MobSpawnTable deepCaveCritters = new MobSpawnTable().add(100, "deepstonecaveling");
    public static MobSpawnTable deepCaveMobs = new MobSpawnTable().add(45, "flamelingshooter");
    public static FishingLootTable availableFishes = new FishingLootTable();

    public boolean canRain(Level level) {
        return true;
    }

    public MobSpawnTable getCritterSpawnTable(Level level) {
        if (level.isCave) {
            return level.getIdentifier().equals(LevelIdentifier.DEEP_CAVE_IDENTIFIER) ? deepCaveCritters : caveCritters;
        }
        return super.getCritterSpawnTable(level);
    }

    public MobSpawnTable getMobSpawnTable(Level level) {
        if (!level.isCave) {
            return surfaceCritters;
        }
        return level.getIdentifier().equals(LevelIdentifier.DEEP_CAVE_IDENTIFIER) ? deepCaveMobs : caveCritters;
    }

    public float getSpawnRateMod(Level level) {
        return super.getSpawnRateMod(level) * 0.25f;
    }

    public float getSpawnCapMod(Level level) {
        return super.getSpawnCapMod(level) * 0.25f;
    }

    public int getGenerationWaterTileID() {
        return TileRegistry.getTileID((String)"watertile");
    }

    public int getGenerationTerrainTileID() {
        return TileRegistry.getTileID((String)"watertile");
    }

    public int getGenerationBeachTileID() {
        return TileRegistry.getTileID((String)"watertile");
    }

    public VillageSet[] getVillageSets() {
        return null;
    }

    public void generateRegionCaveTerrain(Region region, BiomeGeneratorStack stack, GameRandom random) {
        super.generateRegionCaveTerrain(region, stack, random);
        stack.startPlace((Biome)this, region, random).chance((double)0.005f).placeObject("caverock");
        stack.startPlace((Biome)this, region, random).chance((double)0.01f).placeObject("caverocksmall");
        stack.startPlace((Biome)this, region, random).chance((double)0.03f).placeCrates(new String[]{"crate"});
        stack.startPlaceOnVein((Biome)this, region, random, "forestClay").onlyOnObject(ObjectRegistry.rockID).placeObjectForced("clayrock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestCopper").onlyOnObject(ObjectRegistry.rockID).placeObjectForced("copperorerock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestIron").onlyOnObject(ObjectRegistry.rockID).placeObjectForced("ironorerock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestGold").onlyOnObject(ObjectRegistry.rockID).placeObjectForced("goldorerock");
    }

    public void generateRegionDeepCaveTerrain(Region region, BiomeGeneratorStack stack, GameRandom random) {
        super.generateRegionDeepCaveTerrain(region, stack, random);
        stack.startPlace((Biome)this, region, random).chance((double)0.005f).placeObject("deepcaverock");
        stack.startPlace((Biome)this, region, random).chance((double)0.01f).placeObject("deepcaverocksmall");
        stack.startPlace((Biome)this, region, random).chance((double)0.03f).placeCrates(new String[]{"crate"});
        stack.startPlaceOnVein((Biome)this, region, random, "forestWildCaveGlow").onlyOnTile(TileRegistry.deepRockID).chance((double)0.2f).placeObject("wildcaveglow");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepCopper").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("copperoredeeprock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepIron").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("ironoredeeprock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepGold").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("goldoredeeprock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepObsidian").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("obsidianrock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepTungsten").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("tungstenoredeeprock");
        stack.startPlaceOnVein((Biome)this, region, random, "forestDeepLifeQuartz").onlyOnObject(ObjectRegistry.deepRockID).placeObjectForced("lifequartzdeeprock");
    }

    public FishingLootTable getFishingLootTable(FishingSpot spot) {
        return !spot.tile.level.isCave ? availableFishes : null;
    }
}

