/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import java.awt.geom.Point2D;
import java.util.Random;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.util.TicketSystemList;
import necesse.engine.world.WorldEntity;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.generationModules.GenerationTools;
import necesse.level.maps.incursion.AltarData;
import necesse.level.maps.incursion.BiomeMissionIncursionData;
import necesse.level.maps.incursion.IncursionBiome;
import necesse.level.maps.incursion.IncursionData;

public class Archipelago_TempleArenaLevel
extends IncursionLevel {
    public Archipelago_TempleArenaLevel(LevelIdentifier identifier, int width, int height, WorldEntity worldEntity) {
        super(identifier, width, height, worldEntity);
    }

    public Archipelago_TempleArenaLevel(LevelIdentifier identifier, BiomeMissionIncursionData incursion, WorldEntity worldEntity, AltarData altarData) {
        super(identifier, 74, 74, (IncursionData)incursion, worldEntity);
        int biomeId = BiomeRegistry.getBiomeID((String)"archipelago_templearenaincursion");
        this.baseBiome = BiomeRegistry.getBiome((int)biomeId);
        this.isCave = true;
        this.isProtected = incursion.getTabletTier() >= 5;
        this.generateLevel(incursion);
    }

    public void generateLevel() {
        int centerY;
        int centerX;
        GameRandom random = new GameRandom(this.getSeed());
        int wall = ObjectRegistry.getObjectID((String)"deepsandstonewall");
        int sandBrick = TileRegistry.getTileID((String)"sandbrick");
        int woodFloor = TileRegistry.getTileID((String)"woodfloor");
        int lavaTile = TileRegistry.getTileID((String)"lavatile");
        int fireChalice = ObjectRegistry.getObjectID((String)"templefirechalice");
        TicketSystemList tiles = new TicketSystemList();
        tiles.addObject(100, (Object)sandBrick);
        tiles.addObject(50, (Object)woodFloor);
        for (centerX = 0; centerX < this.tileWidth; ++centerX) {
            for (centerY = 0; centerY < this.tileHeight; ++centerY) {
                this.setTile(centerX, centerY, (Integer)tiles.getRandomObject((Random)random));
            }
        }
        centerX = this.tileWidth / 2;
        centerY = this.tileHeight / 2;
        for (int x = 0; x < this.tileWidth; ++x) {
            for (int y = 0; y < this.tileHeight; ++y) {
                double dist = new Point2D.Float(centerX, centerY).distance(x, y);
                if (dist <= 25.5) {
                    this.setObject(x, y, 0);
                    continue;
                }
                if (dist <= 35.5) {
                    this.setObject(x, y, 0);
                    this.setTile(x, y, lavaTile);
                    continue;
                }
                this.setObject(x, y, wall);
            }
        }
        this.placeObjectAngle(centerX, centerY, 14.0f, -90.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, 45.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, -45.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, 0.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, 90.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, 180.0f, fireChalice, 0, -1.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, 135.0f, fireChalice, 0, 0.0f, 0.0f);
        this.placeObjectAngle(centerX, centerY, 14.0f, -135.0f, fireChalice, 0, 0.0f, 0.0f);
    }

    private void placeObjectAngle(int centerX, int centerY, float radius, float angle, int objectID, int rotation, float xOffset, float yOffset) {
        GameObject object = ObjectRegistry.getObject((int)objectID);
        Point2D.Float dir = GameMath.getAngleDir((float)angle);
        object.placeObject((Level)this, (int)((float)centerX + dir.x * radius + xOffset), (int)((float)centerY + dir.y * radius + yOffset), rotation, false);
    }

    public void generateLevel(BiomeMissionIncursionData incursionData) {
        this.generateLevel();
        IncursionBiome.addReturnPortal((Level)this, (float)1184.0f, (float)1184.0f);
        GenerationTools.checkValid((Level)this);
    }
}

