/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import java.awt.Point;
import java.awt.geom.Point2D;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.util.TicketSystemList;
import necesse.engine.world.WorldEntity;
import necesse.inventory.lootTable.LootTable;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.generationModules.GenerationTools;
import necesse.level.maps.incursion.AltarData;
import necesse.level.maps.incursion.BiomeMissionIncursionData;
import necesse.level.maps.incursion.IncursionBiome;
import necesse.level.maps.incursion.IncursionData;
import necesse.level.maps.presets.furniturePresets.BedDresserPreset;
import necesse.level.maps.presets.furniturePresets.BenchPreset;
import necesse.level.maps.presets.furniturePresets.BookshelfClockPreset;
import necesse.level.maps.presets.furniturePresets.BookshelvesPreset;
import necesse.level.maps.presets.furniturePresets.CabinetsPreset;
import necesse.level.maps.presets.furniturePresets.DeskBookshelfPreset;
import necesse.level.maps.presets.furniturePresets.DinnerTablePreset;
import necesse.level.maps.presets.furniturePresets.DisplayStandClockPreset;
import necesse.level.maps.presets.furniturePresets.ModularDinnerTablePreset;
import necesse.level.maps.presets.furniturePresets.ModularTablesPreset;
import necesse.level.maps.presets.set.FurnitureSet;

public class Archipelago_DungeonArenaLevel
extends IncursionLevel {
    public Archipelago_DungeonArenaLevel(LevelIdentifier identifier, int width, int height, WorldEntity worldEntity) {
        super(identifier, width, height, worldEntity);
    }

    public Archipelago_DungeonArenaLevel(LevelIdentifier identifier, BiomeMissionIncursionData incursion, WorldEntity worldEntity, AltarData altarData) {
        super(identifier, 80, 80, (IncursionData)incursion, worldEntity);
        int biomeId = BiomeRegistry.getBiomeID((String)"archipelago_dungeonarenaincursion");
        this.baseBiome = BiomeRegistry.getBiome((int)biomeId);
        this.isCave = true;
        this.isProtected = incursion.getTabletTier() >= 5;
        this.generateLevel(incursion);
    }

    public void generateLevel(BiomeMissionIncursionData incursionData) {
        int y;
        int x;
        GameRandom random = new GameRandom(this.getSeed());
        int wall = ObjectRegistry.getObjectID((String)"dungeonwall");
        int floor = TileRegistry.getTileID((String)"dungeonfloor");
        int lamp = ObjectRegistry.getObjectID((String)"dungeoncandelabra");
        int centerX = this.tileWidth / 2;
        int centerY = this.tileHeight / 2;
        for (x = 0; x < this.tileWidth; ++x) {
            for (y = 0; y < this.tileHeight; ++y) {
                double dist = new Point2D.Float(centerX, centerY).distance(x, y);
                if (dist <= 30.5) {
                    this.setObject(x, y, 0);
                    continue;
                }
                this.setObject(x, y, wall);
            }
        }
        for (x = 0; x < this.tileWidth; ++x) {
            for (y = 0; y < this.tileHeight; ++y) {
                this.setTile(x, y, floor);
            }
        }
        TicketSystemList furniture = new TicketSystemList();
        furniture.addObject(100, (Object)new BedDresserPreset(FurnitureSet.dungeon, 2));
        furniture.addObject(100, (Object)new BenchPreset(FurnitureSet.dungeon, 2));
        furniture.addObject(100, (Object)new BookshelfClockPreset(FurnitureSet.dungeon, 2));
        furniture.addObject(100, (Object)new BookshelvesPreset(FurnitureSet.dungeon, 2, 3));
        furniture.addObject(100, (Object)new CabinetsPreset(FurnitureSet.dungeon, 2, 3));
        furniture.addObject(100, (Object)new DeskBookshelfPreset(FurnitureSet.dungeon, 2));
        furniture.addObject(100, (Object)new DinnerTablePreset(FurnitureSet.dungeon, 2));
        furniture.addObject(100, (Object)new DisplayStandClockPreset(FurnitureSet.dungeon, 2, (GameRandom)null, (LootTable)null, new Object[0]));
        furniture.addObject(100, (Object)new ModularDinnerTablePreset(FurnitureSet.dungeon, 2, 1));
        furniture.addObject(50, (Object)new ModularTablesPreset(FurnitureSet.dungeon, 2, 2, true));
        for (x = 0; x < this.tileWidth; ++x) {
            for (y = 0; y < this.tileHeight; ++y) {
                if (this.getObjectID(x, y) != 0 || !random.getChance(0.8f)) continue;
                GenerationTools.generateFurniture((Level)this, (GameRandom)random, (int)x, (int)y, (TicketSystemList)furniture, pos -> pos.objectID() == 0);
            }
        }
        Point ladderPos = new Point(40, 15);
        this.setObject(ladderPos.x - 5, ladderPos.y, lamp);
        this.setObject(ladderPos.x + 5, ladderPos.y, lamp);
        for (y = 0; y < 4; ++y) {
            int yOffset = -6 + y * 12;
            this.setObject(ladderPos.x - 8, 50 - yOffset, lamp);
            this.setObject(ladderPos.x + 8, 50 - yOffset, lamp);
            this.setObject(ladderPos.x - 19, 50 - yOffset + 2, lamp);
            this.setObject(ladderPos.x + 19, 50 - yOffset + 2, lamp);
        }
        IncursionBiome.addReturnPortal((Level)this, (float)((float)centerX * 32.0f), (float)((float)centerY * 32.0f));
        GenerationTools.checkValid((Level)this);
    }
}

