/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import archipelago.Archipelago;
import archipelago.ArchipelagoBulletItem;
import archipelago.ArchipelagoBulletWeapon;
import archipelago.ArchipelagoFishItem;
import archipelago.ArchipelagoSpear;
import archipelago.ArchipelagoSword;
import archipelago.WaterBiome;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.registries.EnchantmentRegistry;
import necesse.engine.registries.IncursionBiomeRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.LevelRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.entity.mobs.Mob;
import necesse.inventory.enchants.EquipmentItemEnchant;
import necesse.inventory.enchants.ToolDamageEnchantment;
import necesse.inventory.enchants.ToolItemEnchantment;
import necesse.inventory.item.Item;
import necesse.inventory.item.matItem.MatItem;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.incursion.IncursionBiome;

public class ArchipelagoHelper {
    public static Item NewItem(String name, Item.Rarity rarity, int stackSize, String tooltipid, String[] categories, float value) {
        Item newItem = new MatItem(stackSize, rarity, tooltipid).setItemCategory(categories);
        ItemRegistry.registerItem((String)name, (Item)newItem, (float)value, (boolean)true);
        ++Archipelago.itemAmount;
        ++Archipelago.materialAmount;
        return newItem;
    }

    public static ArchipelagoFishItem NewFishItem(String name, Item.Rarity rarity) {
        int stackSize = 0;
        float value = 0.0f;
        int spoilDuration = 0;
        String[] ingredient = new String[]{""};
        String[] categories = new String[]{""};
        int tickets = 0;
        switch (rarity) {
            case NORMAL: {
                stackSize = 250;
                value = 10.0f;
                spoilDuration = 120;
                ingredient = new String[]{"anycommonfish"};
                categories = new String[]{"consumable", "commonfish"};
                tickets = 100;
                break;
            }
            case COMMON: {
                stackSize = 250;
                value = 12.0f;
                spoilDuration = 120;
                ingredient = new String[]{"anycommonfish"};
                categories = new String[]{"consumable", "commonfish"};
                tickets = 100;
                break;
            }
            case UNCOMMON: {
                stackSize = 250;
                value = 14.0f;
                spoilDuration = 180;
                ingredient = new String[]{"archipelago_anyuncommonfish"};
                categories = new String[]{"consumable", "archipelago_uncommonfish"};
                tickets = 80;
                break;
            }
            case RARE: {
                stackSize = 250;
                value = 20.0f;
                spoilDuration = 240;
                ingredient = new String[]{"archipelago_anyrarefish"};
                categories = new String[]{"consumable", "archipelago_rarefish"};
                tickets = 60;
                break;
            }
            case EPIC: {
                stackSize = 250;
                value = 36.0f;
                spoilDuration = 300;
                ingredient = new String[]{"archipelago_anyepicfish"};
                categories = new String[]{"consumable", "archipelago_epicfish"};
                tickets = 40;
                break;
            }
            case LEGENDARY: {
                stackSize = 250;
                value = 60.0f;
                spoilDuration = 360;
                ingredient = new String[]{"archipelago_anylegendaryfish"};
                categories = new String[]{"consumable", "archipelago_legendaryfish"};
                tickets = 20;
                break;
            }
            case UNIQUE: {
                stackSize = 250;
                value = 180.0f;
                spoilDuration = 420;
                ingredient = new String[]{"archipelago_anyuniquefish"};
                categories = new String[]{"consumable", "archipelago_uniquefish"};
                tickets = 5;
            }
        }
        ArchipelagoFishItem newFish = new ArchipelagoFishItem(stackSize, rarity, ingredient).spoilDuration(spoilDuration).setItemCategory(categories);
        ItemRegistry.registerItem((String)name, (Item)newFish, (float)value, (boolean)true);
        WaterBiome.availableFishes.addWater(tickets, name);
        return newFish;
    }

    public static ArchipelagoBulletItem NewBullet(String name, Class projectileClass, String texturePath, Item.Rarity rarity, float value, Boolean addToNormal) {
        ArchipelagoBulletItem newBullet = new ArchipelagoBulletItem(rarity);
        ItemRegistry.registerItem((String)name, (Item)newBullet, (float)value, (boolean)true);
        ProjectileRegistry.registerProjectile((String)name, (Class)projectileClass, (String)texturePath, (String)(texturePath + "_shadow"));
        if (addToNormal.booleanValue()) {
            ArchipelagoBulletItem.addToNormalAmmoTypes(name);
        }
        ++Archipelago.itemAmount;
        ++Archipelago.materialAmount;
        return newBullet;
    }

    public static ArchipelagoBulletItem OverrideBullet(String name, Item.Rarity rarity, float value, Boolean addToNormal) {
        ArchipelagoBulletItem newBullet = new ArchipelagoBulletItem(rarity, true);
        ItemRegistry.replaceItem((String)name, (Item)newBullet, (float)value, (boolean)true);
        if (addToNormal.booleanValue()) {
            ArchipelagoBulletItem.addToNormalAmmoTypes(name);
        }
        ++Archipelago.itemAmount;
        ++Archipelago.materialAmount;
        return newBullet;
    }

    public static ArchipelagoBulletWeapon NewBulletWeapon(String name, Item.Rarity rarity, int value) {
        ArchipelagoBulletWeapon newWeapon = new ArchipelagoBulletWeapon(value * 5, rarity);
        ItemRegistry.registerItem((String)name, (Item)newWeapon, (float)value, (boolean)true);
        ++Archipelago.itemAmount;
        ++Archipelago.weaponAmount;
        return newWeapon;
    }

    public static ArchipelagoBulletWeapon OverrideBulletWeapon(String name, Item.Rarity rarity, int value) {
        ArchipelagoBulletWeapon newWeapon = new ArchipelagoBulletWeapon(value * 5, rarity, true);
        ItemRegistry.replaceItem((String)name, (Item)newWeapon, (float)value, (boolean)true);
        return newWeapon;
    }

    public static ArchipelagoSword NewSword(String name, Item.Rarity rarity, int value) {
        ArchipelagoSword newWeapon = new ArchipelagoSword(value * 5, rarity);
        ItemRegistry.registerItem((String)name, (Item)newWeapon, (float)value, (boolean)true);
        ++Archipelago.itemAmount;
        ++Archipelago.weaponAmount;
        return newWeapon;
    }

    public static ArchipelagoSpear NewSpear(String name, Item.Rarity rarity, int value) {
        ArchipelagoSpear newWeapon = new ArchipelagoSpear(value * 5, rarity);
        ItemRegistry.registerItem((String)name, (Item)newWeapon, (float)value, (boolean)true);
        ++Archipelago.itemAmount;
        ++Archipelago.weaponAmount;
        return newWeapon;
    }

    public static void NewProjectile(String name, Class projectileClass, String texturePath) {
        ProjectileRegistry.registerProjectile((String)name, (Class)projectileClass, (String)texturePath, (String)(texturePath + "_shadow"));
    }

    public static void NewToolEnchantment(String name, ToolDamageEnchantment enchantment) {
        EnchantmentRegistry.registerToolEnchantment((String)name, (ToolDamageEnchantment)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.toolEnchantmentAmount;
    }

    public static void NewMeleeEnchantment(String name, ToolDamageEnchantment enchantment) {
        EnchantmentRegistry.registerMeleeEnchantment((String)name, (ToolItemEnchantment)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.meleeEnchantmentAmount;
    }

    public static void NewRangedEnchantment(String name, ToolDamageEnchantment enchantment) {
        EnchantmentRegistry.registerRangedEnchantment((String)name, (ToolItemEnchantment)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.rangedEnchantmentAmount;
    }

    public static void NewMagicEnchantment(String name, ToolDamageEnchantment enchantment) {
        EnchantmentRegistry.registerMagicEnchantment((String)name, (ToolItemEnchantment)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.magicEnchantmentAmount;
    }

    public static void NewSummonsEnchantment(String name, ToolDamageEnchantment enchantment) {
        EnchantmentRegistry.registerSummonEnchantment((String)name, (ToolItemEnchantment)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.summonsEnchantmentAmount;
    }

    public static void NewGearEnchantment(String name, EquipmentItemEnchant enchantment) {
        EnchantmentRegistry.registerEquipmentEnchantment((String)name, (EquipmentItemEnchant)enchantment);
        ++Archipelago.enchantmentAmount;
        ++Archipelago.gearEnchantmentAmount;
    }

    public static void NewHostileMob(String name, Class<? extends Mob> mobClass) {
        MobRegistry.registerMob((String)name, mobClass, (boolean)true);
        ++Archipelago.npcAmount;
        ++Archipelago.mobAmount;
    }

    public static void NewBoss(String name, Class<? extends Mob> mobClass) {
        MobRegistry.registerMob((String)name, mobClass, (boolean)true, (boolean)true);
        ++Archipelago.npcAmount;
        ++Archipelago.bossAmount;
    }

    public static void NewBiome(String name, Biome biome, float weight) {
        BiomeRegistry.registerBiome((String)name, (Biome)biome.setGenerationWeight(weight), (boolean)true);
        ++Archipelago.environmentAmount;
        ++Archipelago.biomeAmount;
    }

    public static void NewLevel(String name, Class<? extends Level> level) {
        LevelRegistry.registerLevel((String)name, level);
        ++Archipelago.environmentAmount;
    }

    public static void NewIncursionBiome(String name, IncursionBiome biome, int minimumTier) {
        IncursionBiomeRegistry.registerBiome((String)name, (IncursionBiome)biome, (int)minimumTier);
        ++Archipelago.environmentAmount;
        ++Archipelago.incursionAmount;
    }

    public static void NewIncursion(String name, Biome biome, IncursionBiome incursionBiome, Class<? extends Level> level, int minimumTier) {
        BiomeRegistry.registerBiome((String)name, (Biome)biome, (boolean)false);
        LevelRegistry.registerLevel((String)name, level);
        IncursionBiomeRegistry.registerBiome((String)name, (IncursionBiome)incursionBiome, (int)minimumTier);
        ++Archipelago.environmentAmount;
        ++Archipelago.incursionAmount;
    }
}

