/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import archipelago.ArchipelagoBulletItem;
import archipelago.ArchipelagoBulletProjectileType;
import archipelago.ArchipelagoModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import necesse.engine.GameLog;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.WaitForSecondsEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.AmmoConsumed;
import necesse.entity.mobs.itemAttacker.AmmoUserMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;

public class ArchipelagoBulletWeapon
extends GunProjectileToolItem {
    protected IntUpgradeValue burstCount;
    protected IntUpgradeValue projectileCount;
    protected float rotationOffset;
    protected float barrelOffset;
    protected float barrelHeight;
    protected float inaccuracy;
    protected float zoomAmount;
    protected ListGameTooltips addedTooltips;
    protected Boolean isOverride;
    protected ArrayList<ArchipelagoBulletProjectileType> optionalBullets;
    protected Set<Integer> enchantments;
    protected GameSound sound = GameResources.handgun;
    protected Boolean hasCustomSound;
    protected float soundVolume;
    protected float soundPitch;

    public ArchipelagoBulletWeapon(int enchantPrice, Item.Rarity rare) {
        super(NORMAL_AMMO_TYPES, enchantPrice, GunWeaponsLootTable.gunWeapons);
        this.rarity = rare;
        this.itemAttackerProjectileCanHitWidth = 5.0f;
        this.itemAttackerPredictionDistanceOffset = -20.0f;
        this.canBeUsedForRaids = true;
        this.useForRaidsOnlyIfObtained = true;
        this.burstCount = new IntUpgradeValue(1, 0.0f);
        this.projectileCount = new IntUpgradeValue(1, 0.0f);
        this.rotationOffset = 0.0f;
        this.inaccuracy = 0.0f;
        this.zoomAmount = 0.0f;
        this.isOverride = false;
        this.optionalBullets = new ArrayList();
        this.addedTooltips = new ListGameTooltips();
        this.enchantments = new HashSet<Integer>();
        this.hasCustomSound = false;
        this.soundVolume = 1.0f;
        this.soundPitch = 1.0f;
    }

    public ArchipelagoBulletWeapon(int enchantPrice, Item.Rarity rare, Boolean isOverride) {
        this(enchantPrice, rare);
        this.isOverride = true;
    }

    public InventoryItem onAttack(Level level, final int x, final int y, final ItemAttackerMob attackerMob, int attackHeight, final InventoryItem item, ItemAttackSlot slot, int animAttack, final int seed, final GNDItemMap mapContent) {
        Item bullet;
        final int bulletID = mapContent.getShortUnsigned("bulletID", 65535);
        if (bulletID != 65535 && (bullet = ItemRegistry.getItem((int)bulletID)) != null && bullet.type == Item.Type.BULLET) {
            int burstShotCount = Math.round((float)(this.burstCount.getValue(this.getUpgradeTier(item)) + (Integer)this.getEnchantment(item).getModifier(ArchipelagoModifiers.WEAPON_BURST_COUNT_FLAT) + (Integer)this.getEnchantment(item).getModifier(ArchipelagoModifiers.ARMOR_BURST_COUNT_FLAT)) * ((Float)attackerMob.buffManager.getModifier(ArchipelagoModifiers.WEAPON_BURST_COUNT)).floatValue() * ((Float)attackerMob.buffManager.getModifier(ArchipelagoModifiers.ARMOR_BURST_COUNT)).floatValue());
            float burstBetweenShot = (float)this.attackAnimTime.getValue((float)this.getUpgradeLevel(item)).intValue() / 1000.0f / 2.0f / (float)this.burstCount.getValue((float)this.getUpgradeLevel(item)).intValue();
            for (int i = 0; i < burstShotCount; ++i) {
                final int seedTweak = seed * i;
                level.entityManager.addLevelEventHidden((LevelEvent)new WaitForSecondsEvent(burstBetweenShot * (float)i){

                    public void onWaitOver() {
                        boolean dropItem;
                        boolean shouldFire;
                        boolean consumeAmmo;
                        GameRandom random = new GameRandom((long)(seed + 5));
                        float ammoConsumeChance = ((ArchipelagoBulletItem)bullet).getAmmoConsumeChance() * ArchipelagoBulletWeapon.this.getAmmoConsumeChance(attackerMob, item);
                        boolean bl = consumeAmmo = ammoConsumeChance >= 1.0f || ammoConsumeChance > 0.0f && random.getChance(ammoConsumeChance);
                        if (!consumeAmmo) {
                            shouldFire = true;
                            dropItem = false;
                        } else if (attackerMob instanceof AmmoUserMob) {
                            AmmoConsumed consumed = ((AmmoUserMob)attackerMob).removeAmmo(bullet, 1, "bulletammo");
                            shouldFire = consumed.amount >= 1;
                            dropItem = random.getChance(consumed.dropChance);
                        } else {
                            shouldFire = true;
                            dropItem = false;
                        }
                        if (shouldFire) {
                            ArchipelagoBulletWeapon.this.fireProjectiles(this.level, x, y, attackerMob, item, seed + seedTweak, (ArchipelagoBulletItem)bullet, dropItem, mapContent);
                        } else {
                            GameLog.warn.println(attackerMob.getDisplayName() + " tried to use item " + String.valueOf(bullet == null ? Integer.valueOf(bulletID) : bullet.getStringID()) + " as bullet.");
                        }
                    }
                });
            }
        }
        return item;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, ArchipelagoBulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        Projectile projectile;
        int i;
        GameRandom spreadRandom = new GameRandom((long)seed);
        int range = this.attackRange.getValue(this.getUpgradeTier(item));
        int newProjectileCount = (int)Math.ceil((float)this.projectileCount.getValue(this.getUpgradeTier(item)).intValue() * bullet.getProjectileMultiplier());
        for (i = 0; i < this.optionalBullets.size(); ++i) {
            projectile = ArchipelagoBulletItem.addProjectile(this.optionalBullets.get(i), attackerMob.x, attackerMob.y, x, y, this.velocity.getValue(this.getUpgradeTier(item)).intValue(), range, new GameDamage(this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue()), this.knockback.getValue(this.getUpgradeTier(item)), (Mob)attackerMob);
            projectile.changePosition(attackerMob.x, attackerMob.y + this.barrelHeight);
            projectile.moveDist((double)((int)this.barrelOffset));
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            projectile.setAngle(projectile.getAngle() + spreadRandom.getFloatOffset(0.0f, this.inaccuracy + bullet.getInaccuracy()));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        }
        for (i = 0; i < newProjectileCount; ++i) {
            projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.changePosition(attackerMob.x, attackerMob.y + this.barrelHeight);
            projectile.moveDist((double)((int)this.barrelOffset));
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            projectile.setAngle(projectile.getAngle() + spreadRandom.getFloatOffset(0.0f, this.inaccuracy + bullet.getInaccuracy()));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        }
        if (level.isClient()) {
            if (this.hasCustomSound.booleanValue()) {
                GameSound sound = this.sound;
                if (sound == null) {
                    sound = GameResources.handgun;
                }
                SoundManager.playSound((GameSound)sound, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob));
            } else {
                SoundManager.playSound((GameSound)GameResources.handgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(this.soundVolume).pitch(this.soundPitch * GameRandom.globalRandom.getFloatBetween(0.8f, 1.2f)));
            }
        }
    }

    public Projectile getProjectile(InventoryItem item, ArchipelagoBulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        float velocity = bulletItem.modVelocity(this.getProjectileVelocity(item, (Mob)attackerMob));
        range = bulletItem.modRange(range);
        GameDamage damage = bulletItem.modDamage(this.getAttackDamage(item));
        int knockback = bulletItem.modKnockback(this.getKnockback(item, (Attacker)attackerMob));
        return bulletItem.overrideProjectile() ? bulletItem.getProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, (Mob)attackerMob) : this.getNormalProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        drawOptions.pointRotation(attackDirX, attackDirY).forEachItemSprite(i -> i.itemRotateOffset(this.rotationOffset));
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.addAll((Collection)this.addedTooltips);
        return tooltips;
    }

    public float zoomAmount() {
        return this.zoomAmount;
    }

    public ArchipelagoBulletWeapon setOffset(int attackXOffset, int attackYOffset) {
        this.attackXOffset = attackXOffset;
        this.attackYOffset = attackYOffset;
        return this;
    }

    public ArchipelagoBulletWeapon setBarrelOffset(float barrelOffset, float barrelHeight) {
        this.barrelOffset = barrelOffset;
        this.barrelHeight = barrelHeight;
        return this;
    }

    public ArchipelagoBulletWeapon setConsumeChance(float ammoConsumeChance) {
        this.ammoConsumeChance = ammoConsumeChance;
        return this;
    }

    public ArchipelagoBulletWeapon setAmmoTypes(LinkedHashSet<String> ammoTypes) {
        this.ammoTypes = ammoTypes;
        return this;
    }

    public ArchipelagoBulletWeapon setBurst(int burstCount, int upgradedBurstCount) {
        this.burstCount.setBaseValue(burstCount).setUpgradedValue(1.0f, upgradedBurstCount);
        return this;
    }

    public ArchipelagoBulletWeapon setProjectileCount(int projectileCount, int upgradedProjectileCount) {
        this.projectileCount.setBaseValue(projectileCount).setUpgradedValue(1.0f, upgradedProjectileCount);
        return this;
    }

    public ArchipelagoBulletWeapon setAttackDamage(int damage, int upgradedDamage) {
        this.attackDamage.setBaseValue((float)damage).setUpgradedValue(1.0f, (float)upgradedDamage);
        return this;
    }

    public ArchipelagoBulletWeapon setAnimTime(int animTime, int upgradedAnimTime) {
        this.attackAnimTime.setBaseValue(animTime).setUpgradedValue(1.0f, upgradedAnimTime);
        return this;
    }

    public ArchipelagoBulletWeapon setRange(int range, int upgradedRange) {
        this.attackRange.setBaseValue(range).setUpgradedValue(1.0f, upgradedRange);
        return this;
    }

    public ArchipelagoBulletWeapon setVelocity(int velocity) {
        this.velocity.setBaseValue(velocity);
        return this;
    }

    public ArchipelagoBulletWeapon setKnockback(int knockback, int upgradedKnockback) {
        this.knockback.setBaseValue(knockback).setUpgradedValue(1.0f, upgradedKnockback);
        return this;
    }

    public ArchipelagoBulletWeapon setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public ArchipelagoBulletWeapon setZoomAmount(float zoomAmount) {
        this.zoomAmount = zoomAmount;
        return this;
    }

    public ArchipelagoBulletWeapon setRotationOffset(float rotationOffset) {
        this.rotationOffset = rotationOffset;
        return this;
    }

    public ArchipelagoBulletWeapon setSound(GameSound sound) {
        this.sound = sound;
        this.hasCustomSound = true;
        return this;
    }

    public ArchipelagoBulletWeapon setSound(GameSound sound, float volume) {
        this.sound = sound;
        this.soundVolume = volume;
        this.hasCustomSound = true;
        return this;
    }

    public ArchipelagoBulletWeapon setSound(GameSound sound, float volume, float pitch) {
        this.sound = sound;
        this.soundVolume = volume;
        this.soundPitch = pitch;
        this.hasCustomSound = true;
        return this;
    }

    public ArchipelagoBulletWeapon addBullet(ArchipelagoBulletProjectileType bullet) {
        this.optionalBullets.add(bullet);
        return this;
    }

    public ArchipelagoBulletWeapon addTooltips(String line) {
        this.addedTooltips.add(Localization.translate((String)"itemtooltip", (String)line));
        return this;
    }
}

