/*
 * Decompiled with CFR 0.152.
 */
package archipelago;

import archipelago.ArchipelagoBulletProjectileType;
import archipelago.ArchipelagoProjectileAP;
import archipelago.ArchipelagoProjectileDragonbreath;
import archipelago.ArchipelagoProjectileFlamethrower;
import archipelago.ArchipelagoProjectileFlamethrowerEctoplasm;
import archipelago.ArchipelagoProjectileFlamethrowerNitrogen;
import java.util.Collection;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.LivingShottyLeafProjectile;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BouncingBulletProjectile;
import necesse.entity.projectile.bulletProjectile.CrystalBulletProjectile;
import necesse.entity.projectile.bulletProjectile.FrostBulletProjectile;
import necesse.entity.projectile.bulletProjectile.HandGunBulletProjectile;
import necesse.entity.projectile.bulletProjectile.WebbedGunBulletProjectile;
import necesse.entity.projectile.followingProjectile.VoidBulletProjectile;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;

public class ArchipelagoBulletItem
extends BulletItem {
    protected float ammoConsumeChance;
    protected float projectileMultiplier;
    protected float inaccuracy;
    protected ArchipelagoBulletProjectileType bulletType;
    protected ListGameTooltips addedTooltips;
    protected Boolean isCustom;

    public ArchipelagoBulletItem(Item.Rarity rarity) {
        super(5000);
        this.rarity = rarity;
        this.ammoConsumeChance = 1.0f;
        this.projectileMultiplier = 1.0f;
        this.inaccuracy = 0.0f;
        this.bulletType = ArchipelagoBulletProjectileType.NORMAL;
        this.addedTooltips = new ListGameTooltips();
        this.isCustom = true;
    }

    public ArchipelagoBulletItem(Item.Rarity rarity, Boolean isOverride) {
        this(rarity);
        this.isCustom = false;
    }

    public Projectile getProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage damage, int knockback, Mob owner) {
        switch (this.bulletType) {
            case FLAMETHROWER: {
                return new ArchipelagoProjectileFlamethrower(x, y, targetX, targetY, range, damage, owner);
            }
            case FLAMETHROWER_NITROGEN: {
                return new ArchipelagoProjectileFlamethrowerNitrogen(x, y, targetX, targetY, range, damage, owner);
            }
            case BOUNCING: {
                return new BouncingBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case VOID: {
                return new VoidBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case FROST: {
                return new FrostBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case CRYSTAL: {
                return new CrystalBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case DRAGONBREATH: {
                return new ArchipelagoProjectileDragonbreath(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case AP: {
                return new ArchipelagoProjectileAP(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case FLAMETHROWER_ECTOPLASM: {
                return new ArchipelagoProjectileFlamethrowerEctoplasm(x, y, targetX, targetY, range, damage, owner);
            }
            case LIVING_SHOTTY: {
                return new LivingShottyLeafProjectile(owner.getLevel(), owner, x, y, targetX, targetY, velocity, range, damage, knockback);
            }
            case WEBBED_GUN: {
                return new WebbedGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
        }
        return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
    }

    public static Projectile addProjectile(ArchipelagoBulletProjectileType bulletType, float x, float y, float targetX, float targetY, float velocity, int range, GameDamage damage, int knockback, Mob owner) {
        switch (bulletType) {
            case FLAMETHROWER: {
                return new ArchipelagoProjectileFlamethrower(x, y, targetX, targetY, range, damage, owner);
            }
            case FLAMETHROWER_NITROGEN: {
                return new ArchipelagoProjectileFlamethrowerNitrogen(x, y, targetX, targetY, range, damage, owner);
            }
            case BOUNCING: {
                return new BouncingBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case VOID: {
                return new VoidBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case FROST: {
                return new FrostBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case CRYSTAL: {
                return new CrystalBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case DRAGONBREATH: {
                return new ArchipelagoProjectileDragonbreath(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case AP: {
                return new ArchipelagoProjectileAP(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
            case FLAMETHROWER_ECTOPLASM: {
                return new ArchipelagoProjectileFlamethrowerEctoplasm(x, y, targetX, targetY, range, damage, owner);
            }
            case LIVING_SHOTTY: {
                return new LivingShottyLeafProjectile(owner.getLevel(), owner, x, y, targetX, targetY, velocity, range, damage, knockback);
            }
            case WEBBED_GUN: {
                return new WebbedGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
            }
        }
        return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
    }

    public boolean overrideProjectile() {
        return this.bulletType != ArchipelagoBulletProjectileType.NORMAL;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.addAll((Collection)this.addedTooltips);
        return tooltips;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public float getAmmoConsumeChance() {
        return this.ammoConsumeChance;
    }

    public float getProjectileMultiplier() {
        return this.projectileMultiplier;
    }

    public ArchipelagoBulletItem setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public ArchipelagoBulletItem setAmmoConsumeChance(Float ammoConsumeChance) {
        this.ammoConsumeChance = ammoConsumeChance.floatValue();
        return this;
    }

    public ArchipelagoBulletItem setBulletType(ArchipelagoBulletProjectileType bulletType) {
        this.bulletType = bulletType;
        return this;
    }

    public ArchipelagoBulletItem setInaccuracy(Float inaccuracy) {
        this.inaccuracy = inaccuracy.floatValue();
        return this;
    }

    public ArchipelagoBulletItem setProjectileMultiplier(Float projectileMultiplier) {
        this.projectileMultiplier = projectileMultiplier.floatValue();
        return this;
    }

    public ArchipelagoBulletItem addTooltips(String line) {
        this.addedTooltips.add(Localization.translate((String)"itemtooltip", (String)line));
        return this;
    }

    public static void addToNormalAmmoTypes(String bulletName) {
        GunProjectileToolItem.NORMAL_AMMO_TYPES.add(bulletName);
    }
}

