/*
 * Decompiled with CFR 0.152.
 */
package constructors.item;

import constructors.ConstructorsMod;
import constructors.container.TerraformerContainer;
import constructors.drawables.ConstructorTileDrawable;
import constructors.form.TerraformerContainerForm;
import constructors.item.ConstructorItem;
import java.util.ArrayList;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryAddConsumer;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import necesse.inventory.item.placeableItem.tileItem.TileItem;
import necesse.inventory.recipe.Ingredient;
import necesse.level.gameTile.GameTile;
import necesse.level.maps.Level;
import necesse.level.maps.LevelTile;
import necesse.level.maps.TilePosition;

public class TerraformerItem
extends ConstructorItem {
    public static final boolean SR_NO_MODIFY = true;

    public TerraformerItem() {
        TerraformerContainerForm.playerTerraformer = this;
        this.maxPlacementRange.setBaseValue(12).setUpgradedValue(1.0f, 18);
        this.maxShapeSize.setBaseValue(6).setUpgradedValue(1.0f, 10);
    }

    @Override
    public void initializeShapes() {
        if (this.shapes_initialized) {
            return;
        }
        this.shapes_initialized = true;
        this.shapes.put(ConstructorItem.Shape.SQUARE, new ConstructorItem.ShapeSelectionSquare(this));
        this.shapes.put(ConstructorItem.Shape.LINE_BOX, new ConstructorItem.ShapeSelectionLineBox(this));
        this.shapes.put(ConstructorItem.Shape.CHECKERBOARD, new ConstructorItem.ShapeSelectionCheckerboard(this));
        this.shapes.put(ConstructorItem.Shape.LINE, new ConstructorItem.ShapeSelectionLine(this, ConstructorItem.LineDirection.VERTICAL));
        this.shapes.put(ConstructorItem.Shape.CIRCLE, new ConstructorItem.ShapeSelectionCircle(this));
        this.shapes.put(ConstructorItem.Shape.RING, new ConstructorItem.ShapeSelectionRing(this));
    }

    @Override
    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip1"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip2"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip3"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip4"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip5"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip6"));
        tooltips.add(Localization.translate((String)"terraformer", (String)"terraformertip7"));
        tooltips.add((Object)super.getPreEnchantmentTooltips(item, perspective, blackboard));
        return tooltips;
    }

    @Override
    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem me, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        ArrayList<TileItem> replacedTiles = new ArrayList<TileItem>();
        if (this.currentlyHighlightedTiles != null) {
            LevelTile[][] cloneTiles = (LevelTile[][])this.currentlyHighlightedTiles.clone();
            this.clearOutOfRangeTiles(cloneTiles, (PlayerMob)attackerMob, this.maxPlacementRange.getValue(this.getUpgradeTier(me)));
            int tilesExpended = 0;
            for (int i = 0; i < cloneTiles.length; ++i) {
                for (int j = 0; j < cloneTiles[i].length; ++j) {
                    int numTilesInBucket;
                    LevelTile targetTile = cloneTiles[i][j];
                    if (targetTile == null) continue;
                    TileItem highlightedTileItem = targetTile.tile.getTileItem();
                    TileItem tileInBucket = null;
                    tileInBucket = this.getCurrentTile(me);
                    if (tileInBucket == null || (numTilesInBucket = this.getCurrentTileAmount(me)) < tilesExpended || highlightedTileItem.getID() == tileInBucket.getID() || !level.isServer()) continue;
                    if (highlightedTileItem.getID() != TileRegistry.dirtID) {
                        replacedTiles.add(highlightedTileItem);
                    }
                    ++tilesExpended;
                    level.sendTileChangePacket(level.getServer(), targetTile.tileX, targetTile.tileY, tileInBucket.tileID);
                    level.tileLayer.setIsPlayerPlaced(targetTile.tileX, targetTile.tileY, true);
                }
            }
            if (level.isServer()) {
                if (tilesExpended > 0) {
                    this.removeTilesFromBucket(me, tilesExpended);
                }
                if (replacedTiles.size() > 0 && attackerMob instanceof PlayerMob) {
                    PlayerMob p = (PlayerMob)attackerMob;
                    replacedTiles.forEach(tile -> p.getInv().addItem(new InventoryItem((Item)tile), true, "give", (InventoryAddConsumer)null));
                }
            }
        }
        return me;
    }

    @Override
    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem me, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (!(attackerMob instanceof PlayerMob)) {
            return me;
        }
        PlayerMob p = (PlayerMob)attackerMob;
        if (this.currentlyHighlightedTiles != null) {
            int remainder;
            LevelTile[][] cloneTiles = (LevelTile[][])this.currentlyHighlightedTiles.clone();
            this.clearOutOfRangeTiles(cloneTiles, (PlayerMob)attackerMob, this.maxPlacementRange.getValue(this.getUpgradeTier(me)));
            int addTiles = 0;
            for (int i = 0; i < cloneTiles.length; ++i) {
                for (int j = 0; j < cloneTiles[i].length; ++j) {
                    LevelTile targetTile = cloneTiles[i][j];
                    if (targetTile == null || targetTile.tile.getID() == TileRegistry.dirtID) continue;
                    if (!this.hasTile(me)) {
                        if (!level.isServer()) continue;
                        InventoryItem newItem = new InventoryItem((Item)targetTile.tile.getTileItem());
                        newItem.setAmount(1);
                        this.setTile(level, p, me, newItem);
                        level.sendTileChangePacket(level.getServer(), targetTile.tileX, targetTile.tileY, targetTile.tile.getDestroyedTile());
                        level.tileLayer.setIsPlayerPlaced(targetTile.tileX, targetTile.tileY, true);
                        continue;
                    }
                    if (targetTile.tile.getID() != this.getCurrentTile((InventoryItem)me).tileID || !level.isServer()) continue;
                    ++addTiles;
                    level.sendTileChangePacket(level.getServer(), targetTile.tileX, targetTile.tileY, targetTile.tile.getDestroyedTile());
                    level.tileLayer.setIsPlayerPlaced(targetTile.tileX, targetTile.tileY, true);
                }
            }
            if (level.isServer() && addTiles > 0 && (remainder = this.addCurrentTileAmount(me, addTiles)) > 0) {
                InventoryItem newItem = new InventoryItem((Item)this.getCurrentTile(me));
                newItem.setAmount(remainder);
                p.getInv().addItem(newItem, true, "give", (InventoryAddConsumer)null);
            }
        }
        return me;
    }

    @Override
    public void onMouseHoverTile(InventoryItem me, GameCamera camera, PlayerMob perspective, int mouseX, int mouseY, TilePosition pos, boolean isDebug) {
        if (this.active && this.currentShape != null && perspective != null && perspective.getLevel() != null) {
            if (this.currentShape.shapeID == ConstructorItem.Shape.LINE) {
                ConstructorItem.ShapeSelectionLine cl = (ConstructorItem.ShapeSelectionLine)this.currentShape;
                if (!perspective.isAttacking) {
                    if (perspective.getDir() == 0 || perspective.getDir() == 2) {
                        if (cl.getDirection() != ConstructorItem.LineDirection.VERTICAL) {
                            cl.setDirection(ConstructorItem.LineDirection.VERTICAL);
                        }
                    } else if (cl.getDirection() != ConstructorItem.LineDirection.HORIZONTAL) {
                        cl.setDirection(ConstructorItem.LineDirection.HORIZONTAL);
                    }
                }
            }
            this.currentlyHighlightedTiles = this.currentShape.getTilesAround(perspective, pos);
            TileItem tileInBucket = null;
            int tileID = -1;
            if (this.hasTile(me)) {
                tileInBucket = this.getCurrentTile(me);
                tileID = tileInBucket.tileID;
            }
            this.highlightDraw = new ConstructorTileDrawable<GameTile>(perspective.getLevel(), perspective, camera, this.currentlyHighlightedTiles, tileID, this.maxPlacementRange.getValue(this.getUpgradeTier(me)), lvTile -> lvTile.tile, (lvTile, tgTileID) -> lvTile.getID() == tgTileID.intValue());
            this.highlightDraw.draw(perspective.getLevel().tickManager());
        }
    }

    @Override
    protected void updateContainerForm() {
        if (TerraformerContainerForm.instance != null && !TerraformerContainerForm.instance.isDisposed()) {
            TerraformerContainerForm.instance.updateShapeSizeLabel(this.shapeSize);
        }
    }

    protected void openContainer(ServerClient client, PlayerInventorySlot inventorySlot) {
        PacketOpenContainer p = new PacketOpenContainer(ConstructorsMod.TERRAFORMER_CONTAINER, TerraformerContainer.getContainerContent((InternalInventoryItemInterface)this, (PlayerInventorySlot)inventorySlot));
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public int getInternalInventorySize() {
        return 1;
    }

    public boolean isValidPouchItem(InventoryItem arg0) {
        return this.isValidRequestItem(arg0.item);
    }

    public boolean isValidRequestItem(Item arg0) {
        return arg0 instanceof TileItem;
    }

    public boolean isValidRequestType(Item.Type type) {
        return false;
    }

    public InventoryItem getTileInvItem(InventoryItem me) {
        if (this.hasTile(me)) {
            Inventory _me = this.getInternalInventory(me);
            return _me.getItem(0);
        }
        return null;
    }

    public boolean hasTile(InventoryItem me) {
        Inventory _me = this.getInternalInventory(me);
        return _me.getItemSlot(0) != null && !_me.isSlotClear(0);
    }

    public TileItem getCurrentTile(InventoryItem me) {
        if (this.hasTile(me)) {
            return (TileItem)this.getTileInvItem((InventoryItem)me).item;
        }
        return null;
    }

    public int getCurrentTileAmount(InventoryItem me) {
        if (this.hasTile(me)) {
            Inventory _me = this.getInternalInventory(me);
            return _me.getAmount(0);
        }
        return 0;
    }

    public void setCurrentTileAmount(InventoryItem me, int newAmount) {
        if (this.hasTile(me)) {
            Inventory _me = this.getInternalInventory(me);
            _me.setAmount(0, newAmount);
            this.saveInternalInventory(me, _me);
        }
    }

    public int addCurrentTileAmount(InventoryItem me, int addAmount) {
        if (this.hasTile(me)) {
            Inventory _me = this.getInternalInventory(me);
            int limit = _me.getItemStackLimit(0, this.getTileInvItem(me));
            int currentAmount = this.getCurrentTileAmount(me);
            int newAmount = Math.min(currentAmount + addAmount, limit);
            int overTheLimit = currentAmount + addAmount - limit;
            overTheLimit = Math.max(0, overTheLimit);
            this.setCurrentTileAmount(me, newAmount);
            return overTheLimit;
        }
        return -1;
    }

    private void removeTilesFromBucket(InventoryItem me, int tilesExpended) {
        if (this.hasTile(me)) {
            int now = this.getCurrentTileAmount(me);
            if (now <= tilesExpended) {
                this.setCurrentTileAmount(me, 0);
                return;
            }
            this.setCurrentTileAmount(me, now - tilesExpended);
        }
    }

    public void setTile(Level level, PlayerMob player, InventoryItem me, InventoryItem newItem) {
        Inventory _me = this.getInternalInventory(me);
        _me.addItem(level, player, newItem, "give", null);
        this.saveInternalInventory(me, _me);
    }

    @Override
    protected Ingredient[] getSpecialUpgradeCost(int nextTier) {
        switch (nextTier) {
            case 1: {
                return new Ingredient[]{new Ingredient(TileRegistry.getTile((int)TileRegistry.grassID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.snowID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.sandID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.plainsGrassID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.swampGrassID).getTileItem().getStringID(), 250)};
            }
            case 2: {
                return new Ingredient[]{new Ingredient(TileRegistry.getTile((int)TileRegistry.rockID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.sandstoneID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.swampRockID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.graniteRockID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.snowRockID).getTileItem().getStringID(), 250)};
            }
            case 3: {
                return new Ingredient[]{new Ingredient(TileRegistry.getTile((int)TileRegistry.deepRockID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.deepSandstoneID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.deepSwampRockID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.deepStoneFloorID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.deepSnowRockID).getTileItem().getStringID(), 250)};
            }
            case 4: {
                return new Ingredient[]{new Ingredient(TileRegistry.getTile((int)TileRegistry.dungeonFloorID).getTileItem().getStringID(), 250), new Ingredient(TileRegistry.getTile((int)TileRegistry.lavaID).getTileItem().getStringID(), 100)};
            }
        }
        return new Ingredient[]{new Ingredient("upgradeshard", nextTier * 200)};
    }
}

