/*
 * Decompiled with CFR 0.152.
 */
package constructors.item;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import necesse.engine.GameState;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.world.GameClock;
import necesse.engine.world.WorldSettings;
import necesse.entity.Entity;
import necesse.entity.TileEntity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameColor;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawables.SortedDrawable;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.SpacerGameTooltip;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.DoubleItemStatTip;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.ItemStatTip;
import necesse.inventory.item.ItemStatTipList;
import necesse.inventory.item.LocalMessageDoubleItemStatTip;
import necesse.inventory.item.TickItem;
import necesse.inventory.item.miscItem.PouchItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.item.upgradeUtils.UpgradableItem;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.inventory.recipe.Ingredient;
import necesse.level.maps.Level;
import necesse.level.maps.LevelTile;
import necesse.level.maps.TilePosition;

public abstract class ConstructorItem
extends PouchItem
implements TickItem,
UpgradableItem,
ItemInteractAction {
    public static final int MAX_UPGRADE_TIER = 5;
    public Map<Shape, ShapeSelection> shapes = new HashMap<Shape, ShapeSelection>();
    protected boolean shapes_initialized = false;
    private long lastActivationEventTime;
    protected boolean active = false;
    protected SortedDrawable highlightDraw;
    protected LevelTile[][] currentlyHighlightedTiles;
    protected ShapeSelection currentShape;
    protected IntUpgradeValue maxPlacementRange;
    protected IntUpgradeValue maxShapeSize;
    protected int minShapeSize = 1;
    protected int shapeSize = 4;
    private boolean isSizeUpPressed = false;
    private boolean isSizeDownPressed = false;

    public ConstructorItem() {
        this.initializeShapes();
        this.maxPlacementRange = new IntUpgradeValue(12, 0.5f);
        this.maxShapeSize = new IntUpgradeValue(6, 0.4f);
        this.stackSize = 1;
        this.attackCooldownTime = new IntUpgradeValue().setBaseValue(100);
        this.rarity = Item.Rarity.UNIQUE;
        this.setShape(Shape.SQUARE);
        this.updateShapes(null);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        ItemAttackerMob equippedMob = (ItemAttackerMob)blackboard.get(ItemAttackerMob.class, "equippedMob", (Object)perspective);
        if (equippedMob == null) {
            equippedMob = (ItemAttackerMob)blackboard.get(ItemAttackerMob.class, "perspective", (Object)perspective);
        }
        if (equippedMob == null) {
            equippedMob = perspective;
        }
        tooltips.add((Object)new SpacerGameTooltip(12));
        this.addStatTooltips(tooltips, item, (InventoryItem)blackboard.get(InventoryItem.class, "compareItem"), blackboard.getBoolean("showDifference"), blackboard.getBoolean("forceAdd"), equippedMob);
        tooltips.add((GameMessage)new LocalMessage("constructor.ui", "itemupgradeable"));
        return tooltips;
    }

    public ListGameTooltips getPostEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        return new ListGameTooltips();
    }

    public final ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add((Object)this.getPreEnchantmentTooltips(item, perspective, blackboard));
        tooltips.add((Object)this.getPostEnchantmentTooltips(item, perspective, blackboard));
        return tooltips;
    }

    public String getCanBeUpgradedError(InventoryItem item) {
        return this.getUpgradeTier(item) >= 5.0f ? Localization.translate((String)"constructor.ui", (String)"itemupgradelimit") : null;
    }

    public void addUpgradeStatTips(ItemStatTipList list, InventoryItem lastItem, InventoryItem upgradedItem, ItemAttackerMob perspective, ItemAttackerMob statPerspective) {
        DoubleItemStatTip tierTip = new LocalMessageDoubleItemStatTip("item", "tier", "tiernumber", (double)this.getUpgradeTier(upgradedItem), 2).setCompareValue((double)this.getUpgradeTier(lastItem)).setToString(tier -> {
            int floorTier = (int)tier;
            double percentAdd = tier - (double)floorTier;
            return percentAdd != 0.0 ? floorTier + " (+" + (int)(percentAdd * 100.0) + "%)" : String.valueOf(floorTier);
        });
        list.add(Integer.MIN_VALUE, (ItemStatTip)tierTip);
        this.addStatTooltips(list, upgradedItem, lastItem, perspective, true);
    }

    public final void addStatTooltips(ListGameTooltips tooltips, InventoryItem currentItem, InventoryItem lastItem, boolean showDifference, boolean forceAdd, ItemAttackerMob perspective) {
        ItemStatTipList list = new ItemStatTipList();
        this.addStatTooltips(list, currentItem, lastItem, perspective, forceAdd);
        for (ItemStatTip itemStatTip : list) {
            tooltips.add((Object)itemStatTip.toTooltip((Color)GameColor.GREEN.color.get(), (Color)GameColor.RED.color.get(), (Color)GameColor.YELLOW.color.get(), showDifference));
        }
    }

    public void addToolTierTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, boolean forceAdd) {
        float lastTier;
        float tier = this.getUpgradeTier(currentItem);
        float f = lastTier = lastItem == null ? tier : this.getUpgradeTier(lastItem);
        if (tier != lastTier || forceAdd) {
            LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("itemtooltip", "tooltier", "value", (double)tier, 1);
            if (lastItem != null) {
                tip.setCompareValue((double)lastTier);
            }
            list.add(60, (ItemStatTip)tip);
        }
    }

    public void addMaxRangeTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        int currentMaxRange = this.maxPlacementRange.getValue(this.getUpgradeTier(currentItem));
        LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("constructor.itemtooltip", "rangetip", "value", (double)currentMaxRange, 1);
        if (lastItem != null) {
            int lastMaxRange = this.maxPlacementRange.getValue(this.getUpgradeTier(lastItem));
            tip.setCompareValue((double)lastMaxRange);
        }
        list.add(250, (ItemStatTip)tip);
    }

    public void addMaxSizeTip(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, Mob perspective, boolean forceAdd) {
        int currentMaxSize = this.maxShapeSize.getValue(this.getUpgradeTier(currentItem));
        LocalMessageDoubleItemStatTip tip = new LocalMessageDoubleItemStatTip("constructor.itemtooltip", "sizetip", "value", (double)currentMaxSize, 1);
        if (lastItem != null) {
            int lastMaxSize = this.maxShapeSize.getValue(this.getUpgradeTier(lastItem));
            tip.setCompareValue((double)lastMaxSize);
        }
        list.add(250, (ItemStatTip)tip);
    }

    public void addStatTooltips(ItemStatTipList list, InventoryItem currentItem, InventoryItem lastItem, ItemAttackerMob perspective, boolean forceAdd) {
        this.addMaxRangeTip(list, currentItem, lastItem, (Mob)perspective, forceAdd);
        this.addMaxSizeTip(list, currentItem, lastItem, (Mob)perspective, forceAdd);
    }

    protected int getNextUpgradeTier(InventoryItem item) {
        int currentTier = (int)item.item.getUpgradeTier(item);
        int nextTier = currentTier + 1;
        float baseSizeValue = this.maxShapeSize.getValue(0.0f).intValue();
        float nextTierValue = this.maxShapeSize.getValue((float)nextTier).intValue();
        if (nextTier == 1 && baseSizeValue < nextTierValue) {
            return nextTier;
        }
        while (baseSizeValue / nextTierValue > 1.0f - this.maxShapeSize.defaultLevelIncreaseMultiplier / 4.0f && nextTier < currentTier + 100) {
            nextTierValue = this.maxShapeSize.getValue((float)(++nextTier)).intValue();
        }
        return nextTier;
    }

    public UpgradedItem getUpgradedItem(InventoryItem item) {
        int nextTier = this.getNextUpgradeTier(item);
        InventoryItem upgradedItem = item.copy();
        upgradedItem.item.setUpgradeTier(upgradedItem, (float)nextTier);
        return new UpgradedItem(item, upgradedItem, this.getSpecialUpgradeCost(nextTier));
    }

    protected abstract Ingredient[] getSpecialUpgradeCost(int var1);

    protected float getTier1CostPercent(InventoryItem item) {
        return this.maxShapeSize.getValue(0.0f) / this.maxShapeSize.getValue(1.0f);
    }

    private void updateShapes(InventoryItem _me) {
        this.setShapeMaxSize(_me != null ? this.maxShapeSize.getValue(this.getUpgradeTier(_me)) : this.maxShapeSize.defaultValue);
        this.setShapeSize(this.shapeSize);
        this.updateContainerForm();
    }

    protected abstract void updateContainerForm();

    private void setShapeSize(int i) {
        this.shapeSize = i;
    }

    private void setShapeMaxSize(int i) {
        this.maxShapeSize.setBaseValue(i);
    }

    public int getCurrentShapeSize() {
        return this.shapeSize;
    }

    public void modShapeSize(int mod, InventoryItem _me) {
        this.shapeSize += mod;
        this.shapeSize = Math.min(this.maxShapeSize.getValue(this.getUpgradeTier(_me)), Math.max(this.minShapeSize, this.shapeSize));
        this.updateShapes(_me);
    }

    public abstract void initializeShapes();

    public void setShape(Shape shapeID) {
        this.currentShape = this.shapes.get((Object)shapeID);
    }

    protected void onDeactivateEvent() {
    }

    protected void onActivateEvent() {
    }

    protected void clearOutOfRangeTiles(LevelTile[][] cloneTiles, PlayerMob perspective, int _range) {
        for (int i = 0; i < cloneTiles.length; ++i) {
            for (int j = 0; j < cloneTiles[i].length; ++j) {
                int dy;
                LevelTile targetTile = cloneTiles[i][j];
                if (targetTile == null) continue;
                int tileX = targetTile.tileX;
                int tileY = targetTile.tileY;
                int dx = tileX - perspective.getTileX();
                if (dx * dx + (dy = tileY - perspective.getTileY()) * dy <= _range * _range) continue;
                cloneTiles[i][j] = null;
            }
        }
    }

    public abstract InventoryItem onAttack(Level var1, int var2, int var3, ItemAttackerMob var4, int var5, InventoryItem var6, ItemAttackSlot var7, int var8, int var9, GNDItemMap var10);

    public abstract InventoryItem onLevelInteract(Level var1, int var2, int var3, ItemAttackerMob var4, int var5, InventoryItem var6, ItemAttackSlot var7, int var8, GNDItemMap var9);

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return true;
    }

    public abstract void onMouseHoverTile(InventoryItem var1, GameCamera var2, PlayerMob var3, int var4, int var5, TilePosition var6, boolean var7);

    public void tick(Inventory arg0, int arg1, InventoryItem me, GameClock arg3, GameState arg4, Entity arg5, TileEntity arg65, WorldSettings arg6, Consumer<InventoryItem> arg7) {
        boolean sizeDownPressed;
        super.tick(arg0, arg1, me, arg3, arg4, arg5, arg65, arg6, arg7);
        if (!(arg5 instanceof PlayerMob)) {
            return;
        }
        PlayerMob p = (PlayerMob)arg5;
        if (p.getSelectedItem() == null) {
            return;
        }
        boolean itemSelected = p.getSelectedItem().item == this;
        long currentTime = arg3.getTime();
        if ((double)(currentTime - this.lastActivationEventTime) / 1000.0 > 0.5) {
            if (itemSelected && !this.active) {
                this.active = true;
                this.lastActivationEventTime = currentTime;
                this.onActivateEvent();
            }
            if (!itemSelected && this.active) {
                this.active = false;
                this.lastActivationEventTime = currentTime;
                this.onDeactivateEvent();
            }
        }
        boolean sizeUpPressed = Control.getControl((String)"terraformersizeup").isDown() || Control.getControl((String)"terraformersizeup").isPressed();
        boolean bl = sizeDownPressed = Control.getControl((String)"terraformersizedown").isDown() || Control.getControl((String)"terraformersizedown").isPressed();
        if (sizeUpPressed && !this.isSizeUpPressed) {
            this.modShapeSize(1, me);
            this.isSizeUpPressed = true;
        } else if (!sizeUpPressed) {
            this.isSizeUpPressed = false;
        }
        if (sizeDownPressed && !this.isSizeDownPressed) {
            this.modShapeSize(-1, me);
            this.isSizeDownPressed = true;
        } else if (!sizeDownPressed) {
            this.isSizeDownPressed = false;
        }
    }

    public static enum Shape {
        SQUARE,
        CHECKERBOARD,
        LINE,
        CIRCLE,
        RING,
        LINE_BOX;

    }

    public static abstract class ShapeSelection {
        public final Shape shapeID;
        public final String shapeName;
        protected ConstructorItem item;

        public ShapeSelection(ConstructorItem item, Shape shapeID, String shapeName) {
            this.shapeID = shapeID;
            this.shapeName = shapeName;
            this.item = item;
        }

        public int shapeSize() {
            return this.item != null ? this.item.shapeSize : 3;
        }

        public int maxSize(InventoryItem _me) {
            return this.item != null ? this.item.maxShapeSize.getValue(this.item.getUpgradeTier(_me)) : 10;
        }

        public int minSize() {
            return this.item != null ? this.item.minShapeSize : 1;
        }

        public abstract LevelTile[][] getTilesAround(PlayerMob var1, TilePosition var2);
    }

    public static class ShapeSelectionLine
    extends ShapeSelection {
        private LineDirection direction;

        public ShapeSelectionLine(ConstructorItem item, LineDirection direction) {
            super(item, Shape.LINE, "line");
            this.direction = direction;
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (currentSize == 0) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            LevelTile[][] shape = this.direction == LineDirection.HORIZONTAL ? new LevelTile[1][currentSize] : (this.direction == LineDirection.VERTICAL ? new LevelTile[currentSize][1] : new LevelTile[currentSize][currentSize]);
            int startX = p.tileX;
            int startY = p.tileY;
            block6: for (int i = 0; i < currentSize; ++i) {
                int x = startX;
                int y = startY;
                switch (this.direction.ordinal()) {
                    case 0: {
                        x = startX - currentSize / 2 + i;
                        y = startY;
                        if (i < 0 || i >= currentSize) continue block6;
                        shape[0][i] = l.getLevelTile(x, y);
                        continue block6;
                    }
                    case 1: {
                        x = startX;
                        y = startY - currentSize / 2 + i;
                        if (i < 0 || i >= currentSize) continue block6;
                        shape[i][0] = l.getLevelTile(x, y);
                        continue block6;
                    }
                    case 2: {
                        x = startX - currentSize / 2 + i;
                        y = startY - currentSize / 2 + i;
                        if (i < 0 || i >= currentSize) continue block6;
                        shape[i][i] = l.getLevelTile(x, y);
                        continue block6;
                    }
                    case 3: {
                        x = startX + currentSize / 2 - i;
                        y = startY - currentSize / 2 + i;
                        if (i < 0 || i >= currentSize) continue block6;
                        shape[i][currentSize - i - 1] = l.getLevelTile(x, y);
                    }
                }
            }
            return shape;
        }

        public ShapeSelectionLine setDirection(LineDirection direction) {
            this.direction = direction;
            return this;
        }

        public LineDirection getDirection() {
            return this.direction;
        }
    }

    public static class ShapeSelectionRing
    extends ShapeSelection {
        public ShapeSelectionRing(ConstructorItem item) {
            super(item, Shape.RING, "ring");
        }

        @Override
        public int minSize() {
            return this.item != null ? Math.max(3, this.item.minShapeSize) : 3;
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (currentSize < 3) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            int radius = currentSize / 2;
            int innerRadius = Math.max(1, radius - 1);
            int diameter = radius * 2 + 1;
            LevelTile[][] shape = new LevelTile[diameter][diameter];
            int centerX = p.tileX;
            int centerY = p.tileY;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    int worldX = centerX + x;
                    int worldY = centerY + y;
                    double distance = Math.sqrt(x * x + y * y);
                    if (!(distance <= (double)radius) || !(distance >= (double)innerRadius)) continue;
                    int _x = x + radius;
                    int _y = y + radius;
                    if (_x < 0 || _x >= diameter || _y < 0 || _y >= diameter) continue;
                    shape[_x][_y] = l.getLevelTile(worldX, worldY);
                }
            }
            return shape;
        }
    }

    public static class ShapeSelectionCircle
    extends ShapeSelection {
        public ShapeSelectionCircle(ConstructorItem item) {
            super(item, Shape.CIRCLE, "circle");
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (this.shapeSize() < 3) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            int radius = currentSize / 2;
            int diameter = radius * 2 + 1;
            LevelTile[][] shape = new LevelTile[diameter][diameter];
            int centerX = p.tileX;
            int centerY = p.tileY;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    int worldX = centerX + x;
                    int worldY = centerY + y;
                    double distance = Math.sqrt(x * x + y * y);
                    if (!(distance <= (double)radius)) continue;
                    int _x = x + radius;
                    int _y = y + radius;
                    if (_x < 0 || _x >= diameter || _y < 0 || _y >= diameter) continue;
                    shape[_x][_y] = l.getLevelTile(worldX, worldY);
                }
            }
            return shape;
        }
    }

    public static class ShapeSelectionCheckerboard
    extends ShapeSelection {
        public ShapeSelectionCheckerboard(ConstructorItem item) {
            super(item, Shape.CHECKERBOARD, "checkerboard");
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (currentSize == 0 || player == null) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            LevelTile[][] shape = new LevelTile[currentSize][currentSize];
            int startX = p.tileX - currentSize / 2;
            int startY = p.tileY - currentSize / 2;
            int endX = p.tileX + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int endY = p.tileY + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int _x = 0;
            for (int x = startX; x <= endX; ++x) {
                int _y = 0;
                for (int y = startY; y <= endY; ++y) {
                    shape[_x][_y] = (_x + _y) % 2 == 0 ? l.getLevelTile(x, y) : null;
                    ++_y;
                }
                ++_x;
            }
            return shape;
        }
    }

    public static class ShapeSelectionLineBox
    extends ShapeSelection {
        public ShapeSelectionLineBox(ConstructorItem item) {
            super(item, Shape.LINE_BOX, "linebox");
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (currentSize == 0 || player == null) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            LevelTile[][] shape = new LevelTile[currentSize][currentSize];
            int startX = p.tileX - currentSize / 2;
            int startY = p.tileY - currentSize / 2;
            int endX = p.tileX + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int endY = p.tileY + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int _x = 0;
            for (int x = startX; x <= endX; ++x) {
                int _y = 0;
                for (int y = startY; y <= endY; ++y) {
                    shape[_x][_y] = x == startX || x == endX || y == startY || y == endY ? l.getLevelTile(x, y) : null;
                    ++_y;
                }
                ++_x;
            }
            return shape;
        }
    }

    public static class ShapeSelectionSquare
    extends ShapeSelection {
        public ShapeSelectionSquare(ConstructorItem item) {
            super(item, Shape.SQUARE, "square");
        }

        @Override
        public LevelTile[][] getTilesAround(PlayerMob player, TilePosition p) {
            int currentSize = this.shapeSize();
            if (this.shapeSize() == 0 || player == null) {
                return new LevelTile[0][0];
            }
            Level l = player.getLevel();
            LevelTile[][] shape = new LevelTile[currentSize][currentSize];
            int startX = p.tileX - currentSize / 2;
            int startY = p.tileY - currentSize / 2;
            int endX = p.tileX + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int endY = p.tileY + currentSize / 2 + (currentSize % 2 == 0 ? -1 : 0);
            int _x = 0;
            for (int x = startX; x <= endX; ++x) {
                int _y = 0;
                for (int y = startY; y <= endY; ++y) {
                    shape[_x][_y] = l.getLevelTile(x, y);
                    ++_y;
                }
                ++_x;
            }
            return shape;
        }
    }

    public static enum LineDirection {
        HORIZONTAL,
        VERTICAL,
        DIAGONAL_TL_BR,
        DIAGONAL_TR_BL;

    }
}

