/*
 * Decompiled with CFR 0.152.
 */
package constructors.item;

import constructors.ConstructorsMod;
import constructors.container.BuilderContainer;
import constructors.drawables.ConstructorTileDrawable;
import constructors.form.BuilderContainerForm;
import constructors.item.ConstructorItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.Performance;
import necesse.engine.gameLoop.tickManager.PerformanceTimerManager;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.SharedTextureDrawOptions;
import necesse.gfx.gameTexture.GameTextureSection;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryAddConsumer;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.miscItem.InternalInventoryItemInterface;
import necesse.inventory.item.placeableItem.objectItem.ObjectItem;
import necesse.inventory.recipe.Ingredient;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectPlaceOption;
import necesse.level.gameObject.WallObject;
import necesse.level.maps.Level;
import necesse.level.maps.LevelTile;
import necesse.level.maps.TilePosition;
import necesse.level.maps.layers.LevelLayer;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.light.LightManager;

public class BuilderItem
extends ConstructorItem {
    public static final boolean SR_NO_MODIFY = true;

    public BuilderItem() {
        BuilderContainerForm.playerTerraformer = this;
        this.maxPlacementRange.setBaseValue(12).setUpgradedValue(1.0f, 18);
        this.maxShapeSize.setBaseValue(6).setUpgradedValue(1.0f, 10);
    }

    @Override
    public void initializeShapes() {
        if (this.shapes_initialized) {
            return;
        }
        this.shapes_initialized = true;
        this.shapes.put(ConstructorItem.Shape.SQUARE, new ConstructorItem.ShapeSelectionSquare(this));
        this.shapes.put(ConstructorItem.Shape.LINE_BOX, new ConstructorItem.ShapeSelectionLineBox(this));
        this.shapes.put(ConstructorItem.Shape.CHECKERBOARD, new ConstructorItem.ShapeSelectionCheckerboard(this));
        this.shapes.put(ConstructorItem.Shape.LINE, new ConstructorItem.ShapeSelectionLine(this, ConstructorItem.LineDirection.VERTICAL));
        this.shapes.put(ConstructorItem.Shape.CIRCLE, new ConstructorItem.ShapeSelectionCircle(this));
        this.shapes.put(ConstructorItem.Shape.RING, new ConstructorItem.ShapeSelectionRing(this));
    }

    @Override
    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip1"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip2"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip3"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip4"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip5"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip6"));
        tooltips.add(Localization.translate((String)"builder", (String)"buildertip7"));
        tooltips.add((Object)super.getPreEnchantmentTooltips(item, perspective, blackboard));
        return tooltips;
    }

    @Override
    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem me, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        ArrayList<ObjectItem> replacedObjects = new ArrayList<ObjectItem>();
        if (this.currentlyHighlightedTiles != null) {
            LevelTile[][] cloneTiles = this.getSelectedTiles();
            this.clearOutOfRangeTiles(cloneTiles, (PlayerMob)attackerMob, this.maxPlacementRange.getValue(this.getUpgradeTier(me)));
            int objectsExpended = 0;
            for (int i = 0; i < cloneTiles.length; ++i) {
                for (int j = 0; j < cloneTiles[i].length; ++j) {
                    ObjectPlaceOption po;
                    int numTilesInBucket;
                    LevelTile targetTile = cloneTiles[i][j];
                    if (targetTile == null) continue;
                    ObjectItem highlightedObjectItem = level.objectLayer.getObject(1, targetTile.tileX, targetTile.tileY).getObjectItem();
                    ObjectItem objectInBucket = null;
                    objectInBucket = this.getCurrentObject(me);
                    if (objectInBucket == null || (numTilesInBucket = this.getCurrentObjectAmount(me)) < objectsExpended || highlightedObjectItem != null && highlightedObjectItem.getID() == objectInBucket.getID() || (po = objectInBucket.getBestPlaceOption(level, targetTile.tileX * 32, targetTile.tileY * 32, this.getObjectInvItem(me), (PlayerMob)attackerMob, (Line2D)null, true)) == null) continue;
                    boolean canPlace = true;
                    String checkResult = objectInBucket.getObject().canPlace(level, po.tileX * 32, po.tileY * 32, po.rotation, true);
                    boolean bl = canPlace = canPlace && checkResult != "liquid" && checkResult != "shore";
                    if (!canPlace || !level.isServer()) continue;
                    if (highlightedObjectItem != null && highlightedObjectItem.getObject().getID() != ObjectRegistry.getObjectID((String)"air")) {
                        replacedObjects.add(highlightedObjectItem);
                    }
                    ++objectsExpended;
                    objectInBucket.getObject().placeObject(level, po.tileX, po.tileY, po.rotation, true);
                    level.sendObjectUpdatePacket(po.tileX, po.tileY);
                }
            }
            if (level.isServer()) {
                if (objectsExpended > 0) {
                    this.removeObjectsFromBucket(me, objectsExpended);
                }
                if (replacedObjects.size() > 0 && attackerMob instanceof PlayerMob) {
                    PlayerMob p = (PlayerMob)attackerMob;
                    replacedObjects.forEach(tile -> p.getInv().addItem(new InventoryItem((Item)tile), true, "give", (InventoryAddConsumer)null));
                }
            }
        }
        return me;
    }

    @Override
    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem me, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (!(attackerMob instanceof PlayerMob)) {
            return me;
        }
        PlayerMob p = (PlayerMob)attackerMob;
        if (this.currentlyHighlightedTiles != null) {
            int remainder;
            LevelTile[][] cloneTiles = this.getSelectedTiles();
            this.clearOutOfRangeTiles(cloneTiles, (PlayerMob)attackerMob, this.maxPlacementRange.getValue(this.getUpgradeTier(me)));
            int addCurrentObjects = 0;
            for (int i = 0; i < cloneTiles.length; ++i) {
                for (int j = 0; j < cloneTiles[i].length; ++j) {
                    LevelTile targetTile = cloneTiles[i][j];
                    if (targetTile == null) continue;
                    for (LevelLayer _layer : level.layers) {
                        GameObject gameObjOnTile = level.objectLayer.getObject(_layer.getID(), targetTile.tileX, targetTile.tileY);
                        ObjectItem objectOnTile = gameObjOnTile.getObjectItem();
                        if (!this.hasObject(me)) {
                            if (level.isServer() && objectOnTile.getID() != ObjectRegistry.getObjectID((String)"air")) {
                                InventoryItem newItem = new InventoryItem((Item)objectOnTile);
                                newItem.setAmount(1);
                                this.setObject(level, p, me, newItem);
                            }
                            level.objectLayer.setObject(_layer.getID(), targetTile.tileX, targetTile.tileY, 0);
                            level.sendObjectUpdatePacket(targetTile.tileX, targetTile.tileY);
                            continue;
                        }
                        if (objectOnTile.getID() != this.getCurrentObject(me).getID()) continue;
                        if (level.isServer()) {
                            ++addCurrentObjects;
                        }
                        level.objectLayer.setObject(_layer.getID(), targetTile.tileX, targetTile.tileY, 0);
                        level.sendObjectUpdatePacket(targetTile.tileX, targetTile.tileY);
                    }
                }
            }
            if (level.isServer() && addCurrentObjects > 0 && (remainder = this.addCurrentObjectAmount(me, addCurrentObjects)) > 0) {
                InventoryItem newItem = new InventoryItem((Item)this.getCurrentObject(me));
                newItem.setAmount(remainder);
                p.getInv().addItem(newItem, true, "give", (InventoryAddConsumer)null);
            }
        }
        return me;
    }

    @Override
    public void onMouseHoverTile(final InventoryItem me, final GameCamera camera, PlayerMob perspective, int mouseX, int mouseY, TilePosition pos, boolean isDebug) {
        if (this.active && this.currentShape != null && perspective != null && perspective.getLevel() != null) {
            ObjectItem objectInBucket;
            if (this.currentShape.shapeID == ConstructorItem.Shape.LINE) {
                ConstructorItem.ShapeSelectionLine cl = (ConstructorItem.ShapeSelectionLine)this.currentShape;
                if (!perspective.isAttacking) {
                    if (perspective.getDir() == 0 || perspective.getDir() == 2) {
                        if (cl.getDirection() != ConstructorItem.LineDirection.VERTICAL) {
                            cl.setDirection(ConstructorItem.LineDirection.VERTICAL);
                        }
                    } else if (cl.getDirection() != ConstructorItem.LineDirection.HORIZONTAL) {
                        cl.setDirection(ConstructorItem.LineDirection.HORIZONTAL);
                    }
                }
            }
            this.currentlyHighlightedTiles = this.currentShape.getTilesAround(perspective, pos);
            int objID = -1;
            if (this.hasObject(me)) {
                objectInBucket = this.getCurrentObject(me);
                objID = objectInBucket.getObject().getID();
            } else {
                objectInBucket = null;
            }
            this.highlightDraw = new ConstructorTileDrawable<GameObject>(perspective.getLevel(), perspective, camera, this.currentlyHighlightedTiles, objID, this.maxPlacementRange.getValue(this.getUpgradeTier(me)), lvObj -> lvObj.level.objectLayer.getObject(0, lvObj.tileX, lvObj.tileY), (lvObj, tgtObj) -> lvObj.getID() != tgtObj.intValue());
            ((ConstructorTileDrawable)this.highlightDraw).perTileDrawStep = new ConstructorTileDrawable.TileDrawableOptions(){

                @Override
                public void draw(Level level, PlayerMob perspective, LevelTile tile, ConstructorTileDrawable.TileHighlightType highlightType) {
                    if (tile == null || objectInBucket == null) {
                        return;
                    }
                    if (highlightType == ConstructorTileDrawable.TileHighlightType.OUT_OF_RANGE || highlightType == ConstructorTileDrawable.TileHighlightType.ALREADY_PAINTED_TILE) {
                        return;
                    }
                    ObjectPlaceOption po = objectInBucket.getBestPlaceOption(level, tile.tileX * 32, tile.tileY * 32, BuilderItem.this.getObjectInvItem(me), perspective, (Line2D)null, true);
                    if (po != null) {
                        boolean canPlace = true;
                        String checkResult = objectInBucket.getObject().canPlace(level, po.tileX, po.tileY, po.rotation, true);
                        boolean bl = canPlace = canPlace && checkResult != "liquid" && checkResult != "shore";
                        if (canPlace) {
                            float alpha = 0.5f;
                            po.object.drawMultiTilePreview(level, po.tileX, po.tileY, po.rotation, alpha, perspective, camera);
                        }
                    }
                }
            };
            this.highlightDraw.draw(perspective.getLevel().tickManager());
        }
    }

    public void wallDrawPreview(InventoryItem me, WallObject src, Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        SharedTextureDrawOptions options = new SharedTextureDrawOptions(WallObject.generatedWallTexture);
        this.addWallDrawOptions(me, src, options, level, tileX, tileY, level.lightManager.newLight(150.0f), null, camera, player);
        options.forEachDraw(w -> w.alpha(0.5f)).draw();
    }

    public void addWallDrawOptions(InventoryItem me, WallObject src, SharedTextureDrawOptions options, Level level, int tileX, int tileY, GameLight lightOverride, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        Performance.record((PerformanceTimerManager)tickManager, (String)"wallSetup", () -> {
            Object[] lights;
            int drawX = camera.getTileDrawX(tileX);
            int drawY = camera.getTileDrawY(tileY);
            GameObject[] adj = level.getAdjacentObjects(tileX, tileY);
            LevelTile[][] selectedTiles = this.getSelectedTiles();
            ArrayList<GameObject> adjList = new ArrayList<GameObject>(Arrays.asList(adj));
            LevelTile[][] levelTileArray = selectedTiles;
            int n = levelTileArray.length;
            for (int i = 0; i < n; ++i) {
                LevelTile[] tileRow;
                for (LevelTile tile : tileRow = levelTileArray[i]) {
                    if (tile == null) continue;
                    int deltaX = Math.abs(tile.tileX - tileX);
                    int deltaY = Math.abs(tile.tileY - tileY);
                    if ((deltaX != 1 || deltaY != 0) && (deltaY != 1 || deltaX != 0)) continue;
                    GameObject obj = level.getObject(tile.tileX, tile.tileY);
                    adjList.add(obj);
                }
            }
            adj = adjList.toArray(new GameObject[0]);
            boolean allIsSameWall = true;
            boolean[] sameWall = new boolean[adj.length];
            boolean forceDrawTop = false;
            boolean forceRemoveBot = false;
            for (int i = 0; i < adj.length; ++i) {
                boolean connectedWall;
                GameObject adjObject = adj[i];
                sameWall[i] = connectedWall = src.isConnectedWall(adjObject);
                boolean bl = allIsSameWall = allIsSameWall && connectedWall;
                if (!connectedWall) continue;
                if (i == 1) {
                    if (!(adjObject instanceof WallObject) || !((WallObject)adjObject).isWallDrawingTop()) continue;
                    forceDrawTop = true;
                    continue;
                }
                if (i != 6 || !(adjObject instanceof WallObject) || !((WallObject)adjObject).isWallDrawingTop()) continue;
                forceRemoveBot = true;
            }
            float alpha = 1.0f;
            if (perspective != null && !Settings.hideUI && !Settings.hideCursor) {
                Rectangle alphaRec = new Rectangle(tileX * 32 - 16, tileY * 32 - 32, 64, 48);
                if (perspective.getCollision().intersects(alphaRec)) {
                    alpha = 0.5f;
                } else if (alphaRec.contains(camera.getX() + WindowManager.getWindow().mousePos().sceneX, camera.getY() + WindowManager.getWindow().mousePos().sceneY)) {
                    alpha = 0.5f;
                }
            }
            if (lightOverride == null) {
                Point[] var10003 = Level.adjacentGettersWithCenter;
                LightManager var10004 = level.lightManager;
                Objects.requireNonNull(var10004);
                lights = (GameLight[])level.getRelative(tileX, tileY, var10003, (arg_0, arg_1) -> ((LightManager)var10004).getLightLevelWall(arg_0, arg_1), GameLight[]::new);
            } else {
                lights = new GameLight[9];
                Arrays.fill(lights, lightOverride);
            }
            GameTextureSection wallTexture = src.wallTexture;
            src.addWallDrawOptions(options, wallTexture, drawX, drawY, (GameLight[])lights, alpha, sameWall, allIsSameWall, forceDrawTop, forceRemoveBot);
        });
    }

    private LevelTile[][] getSelectedTiles() {
        return (LevelTile[][])this.currentlyHighlightedTiles.clone();
    }

    public boolean isConnectedWall(WallObject me, GameObject them) {
        return them == me || me.connectedWalls.contains(them.getID());
    }

    @Override
    protected void updateContainerForm() {
        if (BuilderContainerForm.instance != null && !BuilderContainerForm.instance.isDisposed()) {
            BuilderContainerForm.instance.updateShapeSizeLabel(this.shapeSize);
        }
    }

    protected void openContainer(ServerClient client, PlayerInventorySlot inventorySlot) {
        PacketOpenContainer p = new PacketOpenContainer(ConstructorsMod.BUILDER_CONTAINER, BuilderContainer.getContainerContent((InternalInventoryItemInterface)this, (PlayerInventorySlot)inventorySlot));
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public int getInternalInventorySize() {
        return 1;
    }

    public boolean isValidPouchItem(InventoryItem arg0) {
        return this.isValidRequestItem(arg0.item);
    }

    public boolean isValidRequestItem(Item arg0) {
        return arg0 instanceof ObjectItem;
    }

    public boolean isValidRequestType(Item.Type type) {
        return false;
    }

    public InventoryItem getObjectInvItem(InventoryItem me) {
        if (this.hasObject(me)) {
            Inventory _me = this.getInternalInventory(me);
            return _me.getItem(0);
        }
        return null;
    }

    public boolean hasObject(InventoryItem me) {
        Inventory _me = this.getInternalInventory(me);
        return _me.getItemSlot(0) != null && !_me.isSlotClear(0);
    }

    public ObjectItem getCurrentObject(InventoryItem me) {
        if (this.hasObject(me)) {
            return (ObjectItem)this.getObjectInvItem((InventoryItem)me).item;
        }
        return null;
    }

    public int getCurrentObjectAmount(InventoryItem me) {
        if (this.hasObject(me)) {
            Inventory _me = this.getInternalInventory(me);
            return _me.getAmount(0);
        }
        return 0;
    }

    public void setCurrentObjectAmount(InventoryItem me, int newAmount) {
        if (this.hasObject(me)) {
            Inventory _me = this.getInternalInventory(me);
            _me.setAmount(0, newAmount);
            this.saveInternalInventory(me, _me);
        }
    }

    public int addCurrentObjectAmount(InventoryItem me, int addAmount) {
        if (this.hasObject(me)) {
            Inventory _me = this.getInternalInventory(me);
            int limit = _me.getItemStackLimit(0, this.getObjectInvItem(me));
            int currentAmount = this.getCurrentObjectAmount(me);
            int newAmount = Math.min(currentAmount + addAmount, limit);
            int overTheLimit = currentAmount + addAmount - limit;
            overTheLimit = Math.max(0, overTheLimit);
            this.setCurrentObjectAmount(me, newAmount);
            return overTheLimit;
        }
        return -1;
    }

    private void removeObjectsFromBucket(InventoryItem me, int amount) {
        if (this.hasObject(me)) {
            int now = this.getCurrentObjectAmount(me);
            if (now <= amount) {
                this.setCurrentObjectAmount(me, 0);
                return;
            }
            this.setCurrentObjectAmount(me, now - amount);
        }
    }

    public void setObject(Level level, PlayerMob player, InventoryItem me, InventoryItem newItem) {
        Inventory _me = this.getInternalInventory(me);
        _me.addItem(level, player, newItem, "give", null);
        this.saveInternalInventory(me, _me);
    }

    @Override
    protected Ingredient[] getSpecialUpgradeCost(int nextTier) {
        switch (nextTier) {
            case 1: {
                return new Ingredient[]{new Ingredient(ObjectRegistry.getObject((String)"woodwall").getObjectItem().getStringID(), 250)};
            }
            case 2: {
                return new Ingredient[]{new Ingredient(ObjectRegistry.getObject((String)"sandstonerock").getObjectItem().getStringID(), 250), new Ingredient(ObjectRegistry.getObject((String)"rock").getObjectItem().getStringID(), 250), new Ingredient(ObjectRegistry.getObject((String)"snowrock").getObjectItem().getStringID(), 250)};
            }
            case 3: {
                return new Ingredient[]{new Ingredient(ObjectRegistry.getObject((String)"deepsandstonerock").getObjectItem().getStringID(), 250), new Ingredient(ObjectRegistry.getObject((String)"deepsnowrock").getObjectItem().getStringID(), 250), new Ingredient(ObjectRegistry.getObject((String)"deeprock").getObjectItem().getStringID(), 250)};
            }
            case 4: {
                return new Ingredient[]{new Ingredient(ObjectRegistry.getObject((String)"dungeonwall").getObjectItem().getStringID(), 500)};
            }
        }
        return new Ingredient[]{new Ingredient("upgradeshard", nextTier * 200)};
    }
}

