/*
 * Decompiled with CFR 0.152.
 */
package constructors.form;

import constructors.container.TerraformerContainer;
import constructors.item.ConstructorItem;
import constructors.item.TerraformerItem;
import java.awt.Rectangle;
import java.util.Map;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormDropdownButton;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormIconButton;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.components.lists.FormIngredientRecipeList;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.forms.presets.containerComponent.ContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonStateTextures;
import necesse.gfx.ui.GameInterfaceStyle;
import necesse.inventory.container.item.ItemInventoryContainer;

public class TerraformerContainerForm<T extends TerraformerContainer>
extends ContainerForm<T> {
    public static TerraformerItem playerTerraformer;
    public static TerraformerContainerForm instance;
    public FormTextInput searchFilter;
    public FormContainerSlot materialSlot;
    public FormIngredientRecipeList ingredientList;
    public int itemID;
    private FormIconButton iconMinusComponent;
    private FormIconButton iconPlusComponent;
    private FormLocalLabel shapeSizeLabelText;
    private FormDropdownButton shapeSelecter;

    public TerraformerContainerForm(Client client, T container) {
        super(client, 300, 100, container);
        instance = this;
        GameInterfaceStyle DefaultGameInterfaceStyle = GameInterfaceStyle.getStyle((String)GameInterfaceStyle.defaultPath);
        ButtonStateTextures bst_Plus = new ButtonStateTextures(DefaultGameInterfaceStyle, "button_plus");
        ButtonStateTextures bst_Minus = new ButtonStateTextures(DefaultGameInterfaceStyle, "button_minus");
        this.addComponent((FormComponent)new FormLocalLabel((GameMessage)new StaticMessage("Terraformer Settings"), new FontOptions(20), -1, 10, 10));
        this.materialSlot = new FormContainerSlot(client, this.container, ((ItemInventoryContainer)this.container).INVENTORY_START, this.getWidth() - 60, this.getHeight() - 50);
        this.addComponent((FormComponent)this.materialSlot);
        FormContentBox sizeAdjustmentWrapperBox = new FormContentBox(this.getX() + 30, 50, 200, 20);
        FormFlow flow = new FormFlow();
        FormLocalLabel adjustmentAreaText = new FormLocalLabel("terraformer", "shapeadjustment", new FontOptions(12), 40, 5, 0, 100);
        this.iconMinusComponent = new FormIconButton(0, 0, bst_Minus, 20, 20, new GameMessage[]{new LocalMessage("terraformer", "decreasesize")});
        this.iconMinusComponent.onClicked(event -> {
            if (playerTerraformer == null) {
                return;
            }
            playerTerraformer.modShapeSize(-1, container.getInventoryItem());
        });
        this.shapeSizeLabelText = new FormLocalLabel("shapesize", "0", new FontOptions(16), 0, 0, 0, 20);
        this.iconPlusComponent = new FormIconButton(0, 0, bst_Plus, 20, 20, new GameMessage[]{new LocalMessage("terraformer", "increasesize")});
        this.iconPlusComponent.onClicked(event -> {
            if (playerTerraformer == null) {
                return;
            }
            playerTerraformer.modShapeSize(1, container.getInventoryItem());
        });
        this.shapeSelecter = new FormDropdownButton(25, this.getBoundingBox().height - 30, FormInputSize.SIZE_16, ButtonColor.BASE, 200, (GameMessage)new LocalMessage("terraformer", "shapeslector"));
        for (Map.Entry s : TerraformerContainerForm.playerTerraformer.shapes.entrySet()) {
            this.shapeSelecter.options.add((GameMessage)new LocalMessage("constructor.shapes", ((ConstructorItem.ShapeSelection)s.getValue()).shapeName), () -> playerTerraformer.setShape((ConstructorItem.Shape)((Object)((Object)s.getKey()))));
        }
        sizeAdjustmentWrapperBox.addComponent((FormComponent)((FormLocalLabel)flow.nextX((FormPositionContainer)adjustmentAreaText)));
        sizeAdjustmentWrapperBox.addComponent((FormComponent)((FormIconButton)flow.nextX((FormPositionContainer)this.iconMinusComponent, 10)));
        sizeAdjustmentWrapperBox.addComponent((FormComponent)((FormLocalLabel)flow.nextX((FormPositionContainer)this.shapeSizeLabelText)));
        sizeAdjustmentWrapperBox.addComponent((FormComponent)((FormIconButton)flow.nextX((FormPositionContainer)this.iconPlusComponent, 10)));
        this.addComponent((FormComponent)sizeAdjustmentWrapperBox);
        this.addComponent((FormComponent)this.shapeSelecter);
        this.updateShapeSizeLabel(playerTerraformer.getCurrentShapeSize());
    }

    public void updateShapeSizeLabel(int currentShapeSize) {
        if (playerTerraformer == null) {
            return;
        }
        this.shapeSizeLabelText.setText(String.valueOf(currentShapeSize));
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        super.draw(tickManager, perspective, renderBox);
    }
}

