/*
 * Decompiled with CFR 0.152.
 */
package moremounts.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class PolarBearMountMob
extends MountFollowingMob {
    public static GameTexture texture;
    public static GameTexture textureShadow;

    public PolarBearMountMob() {
        super(100);
        this.setSpeed(75.0f);
        this.setFriction(10.0f);
        this.setSwimSpeed(1.0f);
        this.collision = new Rectangle(-20, -20, 40, 40);
        this.hitBox = new Rectangle(-30, -25, 60, 50);
        this.selectBox = new Rectangle(-40, -45, 80, 60);
        this.overrideMountedWaterWalking = false;
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 128).light(light).pos(drawX - 2, drawY += this.getLevel().getTile(x / 32, y / 32).getMobSinkingAmount((Mob)this));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        int drawX = camera.getDrawX(x) - 64;
        int drawY = camera.getDrawY(y) - 128 + 36;
        return textureShadow.initDraw().sprite(0, this.getDir(), 128).light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }

    public CollisionFilter getLevelCollisionFilter() {
        return super.getLevelCollisionFilter().allLiquidTiles();
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (this.isAccelerating() && (spriteX == 1 || spriteX == 2)) {
            point.y = -5;
        }
        if (spriteX == 0 || spriteX == 2) {
            point.x = -2;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset() + 5;
        return point;
    }

    public int getRiderDrawYOffset() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null) {
            return -50;
        }
        return 0;
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        PlayerMob following = (PlayerMob)this.getFollowingMob();
        if (following != null && following.isAttacking) {
            return Stream.of(new ModifierValue(BuffModifiers.MAX_HEALTH_FLAT, (Object)50));
        }
        return Stream.of(new ModifierValue(BuffModifiers.MAX_HEALTH_FLAT, (Object)50));
    }
}

