/*
 * Decompiled with CFR 0.152.
 */
package moremounts.mobs;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Stream;
import moremounts.MountPack;
import moremounts.utils.NightVision;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.Packet;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MountAbility;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MountFollowingMob;
import necesse.gfx.PlayerSprite;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class BatMountMob
extends MountFollowingMob
implements MountAbility {
    public static GameTexture texture;
    public static GameTexture textureShadow;
    public static GameTexture textureMask;
    protected int nightVisionCounter = 1;

    public BatMountMob() {
        super(100);
        this.setSpeed(110.0f);
        this.setFriction(1.0f);
        this.setSwimSpeed(1.0f);
        this.accelerationMod = 0.8f;
        this.setKnockbackModifier(0.0f);
        this.collision = new Rectangle(-10, -7, 20, 14);
        this.hitBox = new Rectangle(-14, -14, 28, 28);
        this.selectBox = new Rectangle(-15, -15, 30, 30);
        this.overrideMountedWaterWalking = true;
    }

    public void runMountAbility(PlayerMob player, Packet content) {
        boolean isNight = player.getWorldEntity().isNight();
        if (!isNight) {
            return;
        }
        ++this.nightVisionCounter;
        if (this.nightVisionCounter % 2 == 0) {
            SoundManager.playSound((GameSound)MountPack.toggleNightVisionEffect, (SoundEffect)SoundEffect.globalEffect().volume(0.6f));
        }
    }

    public boolean canRunMountAbility(PlayerMob player, Packet content) {
        return true;
    }

    public void serverTick() {
        super.serverTick();
        if (!this.isMounted()) {
            this.moveX = 0.0f;
            this.moveY = 0.0f;
        }
    }

    public void dismounted() {
        super.dismounted();
        if (this.isClient()) {
            NightVision.turnOffNightVision();
        }
    }

    public void clientTick() {
        super.clientTick();
        boolean isNight = this.getWorldEntity().isNight();
        if (!isNight) {
            NightVision.turnOffNightVision();
            return;
        }
        if (this.nightVisionCounter % 2 == 0) {
            NightVision.turnOnNightVision();
        } else {
            NightVision.turnOffNightVision();
        }
    }

    public int getFlyingHeight() {
        return 1000;
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(x / 32, y / 32);
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 40;
        int dir = this.getDir();
        Point sprite = this.getAnimSprite(x, y, dir);
        TextureDrawOptionsEnd options = texture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY += this.getBobbing(x, y));
        list.add(new MobDrawable((DrawOptions)options){
            final /* synthetic */ DrawOptions val$options;
            {
                this.val$options = drawOptions;
            }

            public void draw(TickManager tickManager) {
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$options.draw();
            }
        });
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        topList.add(arg_0 -> this.lambda$addDrawables$0((DrawOptions)options, player, x, y, light, camera, arg_0));
        this.addShadowDrawables(topList, level, x, y, light, camera);
    }

    public Point getAnimSprite(int x, int y, int dir) {
        return new Point((int)(this.getWorldEntity().getTime() / (long)this.getRockSpeed()) % 4, dir % 4);
    }

    public TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = textureShadow;
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 40;
        int dir = this.getDir();
        drawY += this.getBobbing(x, y);
        return shadowTexture.initDraw().sprite(0, dir, 64).light(light).pos(drawX, drawY += 70);
    }

    public int getRockSpeed() {
        return 500;
    }

    public int getWaterRockSpeed() {
        return 500;
    }

    public Point getSpriteOffset(int spriteX, int spriteY) {
        Point point = new Point(0, 0);
        if (spriteX == 0 || spriteX == 2) {
            point.y = -1;
        }
        point.x += this.getRiderDrawXOffset();
        point.y += this.getRiderDrawYOffset();
        return point;
    }

    public int getRiderDrawYOffset() {
        return -8;
    }

    public int getRiderArmSpriteX() {
        return 1;
    }

    public int getRiderDir(int startDir) {
        return startDir % 4;
    }

    public GameTexture getRiderMask() {
        return textureMask;
    }

    public int getRiderMaskYOffset() {
        return -9;
    }

    public CollisionFilter getLevelCollisionFilter() {
        PlayerMob player = (PlayerMob)this.getFollowingMob();
        if (player != null && player.getLevel() != null && player.getLevel().isCave) {
            return super.getLevelCollisionFilter().overrideFilter(tp -> tp.object().object.isWall || tp.object().object.isRock);
        }
        return super.getLevelCollisionFilter().overrideFilter(tp -> tp.object().object.isWall);
    }

    public Stream<ModifierValue<?>> getDefaultRiderModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.TRAVEL_DISTANCE, (Object)3), new ModifierValue(BuffModifiers.WATER_WALKING, (Object)true));
    }

    private /* synthetic */ void lambda$addDrawables$0(DrawOptions options, PlayerMob player, int x, int y, GameLight light, GameCamera camera, TickManager tm) {
        options.draw();
        if (player != null && this.isMounted()) {
            DrawOptions playerSprite = PlayerSprite.getDrawOptions((PlayerMob)player, (int)x, (int)y, (GameLight)light, (GameCamera)camera, null);
            playerSprite.draw();
        }
    }
}

