/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Projectiles;

import deathrite.Projectiles.AethiumStaffAetherShardProjectile;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class AethiumStaffRidiumBallProjectile
extends Projectile {
    private long spawnTime;
    private float startSpeed;

    public AethiumStaffRidiumBallProjectile() {
    }

    public AethiumStaffRidiumBallProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.setDistance(distance);
        this.setDamage(damage);
        this.knockback = knockback;
        this.setOwner(owner);
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextFloat(this.startSpeed);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.startSpeed = reader.getNextFloat();
    }

    public void init() {
        super.init();
        this.height = 18.0f;
        this.startSpeed = this.speed;
        this.setWidth(10.0f);
        this.spawnTime = this.getLevel().getWorldEntity().getTime();
    }

    public void onMoveTick(Point2D.Float startPos, double movedDist) {
        super.onMoveTick(startPos, movedDist);
        float perc = Math.abs(GameMath.limit((float)(this.traveledDistance / (float)this.distance), (float)0.0f, (float)1.0f) - 1.0f);
        this.speed = Math.max(10.0f, perc * this.startSpeed);
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer()) {
            int projectiles = mob == null ? 8 : 4;
            float startX = x - this.dx * 2.0f;
            float startY = y - this.dy * 2.0f;
            float angle = GameRandom.globalRandom.nextInt(360);
            for (int i = 0; i < projectiles; ++i) {
                Point2D.Float dir = GameMath.getAngleDir((float)(angle + (float)i * 360.0f / (float)projectiles));
                AethiumStaffAetherShardProjectile projectile = new AethiumStaffAetherShardProjectile(this.getLevel(), this.getOwner(), startX, startY, startX + dir.x * 100.0f, startY + dir.y * 100.0f, this.startSpeed, this.distance * 100, this.getDamage().modFinalMultiplier(0.66f), this.knockback);
                if (this.modifier != null) {
                    this.modifier.initChildProjectile((Projectile)projectile, 1.0f, projectiles / 2);
                }
                if (mob != null) {
                    projectile.startHitCooldown(mob);
                }
                this.getLevel().entityManager.projectiles.add((Entity)projectile);
            }
        }
    }

    public Color getParticleColor() {
        return new Color(237, 216, 26);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(69, 20, 125), 12.0f, 200, this.getHeight());
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y) - this.texture.getHeight() / 2;
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, this.texture.getHeight() / 2).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            TextureDrawOptionsEnd shadowOptions = this.shadowTexture.initDraw().light(light).rotate(this.getAngle(), this.shadowTexture.getWidth() / 2, this.shadowTexture.getHeight() / 2).pos(drawX, drawY);
            tileList.add(arg_0 -> AethiumStaffRidiumBallProjectile.lambda$addDrawables$0((TextureDrawOptions)shadowOptions, arg_0));
        }
    }

    public float getAngle() {
        return (float)(this.getWorldEntity().getTime() - this.spawnTime) / 2.0f;
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions shadowOptions, TickManager tm) {
        shadowOptions.draw();
    }
}

