/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Objects.Workstations;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectDamagedTextureArray;
import necesse.level.gameObject.container.CraftingStationObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.multiTile.MultiTile;
import necesse.level.maps.multiTile.SideMultiTile;

public class DeathriteSummoner2Object
extends CraftingStationObject {
    public ObjectDamagedTextureArray texture;
    protected int counterID;

    protected DeathriteSummoner2Object() {
        super(new Rectangle(32, 32));
        this.mapColor = new Color(132, 91, 25);
        this.toolType = ToolType.ALL;
        this.isLightTransparent = true;
        this.hoverHitbox = new Rectangle(0, -16, 32, 48);
    }

    public MultiTile getMultiTile(int rotation) {
        return new SideMultiTile(0, 0, 1, 2, rotation, false, new int[]{this.getID(), this.counterID});
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = ObjectDamagedTextureArray.loadAndApplyOverlay((GameObject)this, (String)"objects/deathritesummoner");
    }

    public Rectangle getCollision(Level level, int x, int y, int rotation) {
        if (rotation == 0) {
            return new Rectangle(x * 32 + 4, y * 32 + 4, 24, 28);
        }
        if (rotation == 1) {
            return new Rectangle(x * 32, y * 32 + 6, 26, 20);
        }
        return rotation == 2 ? new Rectangle(x * 32 + 4, y * 32, 24, 26) : new Rectangle(x * 32 + 6, y * 32 + 6, 26, 20);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        byte rotation = level.getObjectRotation(tileX, tileY);
        GameTexture texture = this.texture.getDamagedTexture((GameObject)this, level, tileX, tileY);
        final DrawOptionsList options = new DrawOptionsList();
        if (rotation == 0) {
            options.add((Object)texture.initDraw().sprite(0, 0, 32).light(light).pos(drawX, drawY - 32));
            options.add((Object)texture.initDraw().sprite(0, 1, 32).light(light).pos(drawX, drawY));
        } else if (rotation == 1) {
            options.add((Object)texture.initDraw().sprite(1, 5, 32).light(light).pos(drawX, drawY - 32));
            options.add((Object)texture.initDraw().sprite(1, 6, 32).light(light).pos(drawX, drawY));
            int flameSprite = (int)(level.getWorldEntity().getWorldTime() % 1200L / 300L);
            options.add((Object)texture.initDraw().sprite(flameSprite % 2, 7 + flameSprite / 2, 32).light(light).pos(drawX, drawY));
        } else if (rotation == 2) {
            options.add((Object)texture.initDraw().sprite(1, 2, 32).light(light).pos(drawX, drawY));
        } else {
            options.add((Object)texture.initDraw().sprite(0, 3, 32).light(light).pos(drawX, drawY - 32));
            options.add((Object)texture.initDraw().sprite(0, 4, 32).light(light).pos(drawX, drawY));
        }
        list.add(new LevelSortedDrawable((GameObject)this, tileX, tileY){

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                options.draw();
            }
        });
    }
}

