/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Mobs.Bosses.StarfangedDestroyer;

import deathrite.DeathriteMod;
import deathrite.Mobs.Bosses.StarfangedDestroyer.StarfangedDestroyerBody;
import deathrite.Mobs.Bosses.StarfangedDestroyer.StarfangedDestroyerTail;
import deathrite.Projectiles.ShootingStarProjectile;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import necesse.engine.DifficultyBasedGetter;
import necesse.engine.achievements.AchievementManager;
import necesse.engine.eventStatusBars.EventStatusBarManager;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modifiers.ModifierValue;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.GameMusic;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.engine.util.gameAreaSearch.GameAreaStream;
import necesse.engine.world.WorldEntity;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.MaxHealthGetter;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobHealthScaling;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.WormMobHead;
import necesse.entity.mobs.ability.CoordinateMobAbility;
import necesse.entity.mobs.ability.MobAbility;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.AINodeResult;
import necesse.entity.mobs.ai.behaviourTree.BehaviourTreeAI;
import necesse.entity.mobs.ai.behaviourTree.Blackboard;
import necesse.entity.mobs.ai.behaviourTree.composites.SelectorAINode;
import necesse.entity.mobs.ai.behaviourTree.composites.SequenceAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.ChargingCirclingChaserAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.RemoveOnNoTargetNode;
import necesse.entity.mobs.ai.behaviourTree.leaves.SpawnProjectilesOnHealthLossAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.TargetFinderAINode;
import necesse.entity.mobs.ai.behaviourTree.leaves.WandererAINode;
import necesse.entity.mobs.ai.behaviourTree.util.AIMover;
import necesse.entity.mobs.ai.behaviourTree.util.FlyingAIMover;
import necesse.entity.mobs.ai.behaviourTree.util.TargetFinderDistance;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.BossNearbyBuff;
import necesse.entity.mobs.hostile.bosses.BossWormMobHead;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.inventory.lootTable.lootItem.RotationLootItem;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class StarfangedDestroyerHead
extends BossWormMobHead<StarfangedDestroyerBody, StarfangedDestroyerHead> {
    static Random random = new Random();
    public static int minstardust = 5;
    public static int maxstardust = 10;
    static int randomNumber = random.nextInt(maxstardust - minstardust + 1) + minstardust;
    public static int mindarkmatter = 1;
    public static int maxdarkmatter = 5;
    static int randomDarkMatterNumber = random.nextInt(maxdarkmatter - mindarkmatter + 1) + mindarkmatter;
    public static LootTable lootTable = new LootTable(new LootItemInterface[]{new LootItem("deathrite_stardust", randomNumber), new LootItem("starfangedlootbag", 1)});
    public static RotationLootItem uniqueDrops = RotationLootItem.privateLootRotation((LootItemInterface[])new LootItemInterface[]{new LootItem("darkmatter", randomDarkMatterNumber)});
    public static LootTable privateLootTable;
    public static float lengthPerBodyPart;
    public static float waveLength;
    public static final int totalBodyParts = 100;
    protected MobHealthScaling scaling = new MobHealthScaling((Mob)this);
    public static GameDamage headCollisionDamage;
    public static GameDamage bodyCollisionDamage;
    public static GameDamage razorDamage;
    public static GameDamage boulderExplosionDamage;
    public static int boulderExplosionRange;
    public static int totalRazorProjectiles;
    public static MaxHealthGetter MAX_HEALTH;
    public final CoordinateMobAbility flickSound;
    public final CoordinateMobAbility swingSound;

    public StarfangedDestroyerHead() {
        super(100, waveLength, 80.0f, 70, 36.0f, -8.0f);
        this.difficultyChanges.setMaxHealth((DifficultyBasedGetter)MAX_HEALTH);
        this.moveAccuracy = 160;
        this.setSpeed(250.0f);
        this.setArmor(30);
        this.accelerationMod = 1.5f;
        this.decelerationMod = 1.5f;
        this.collision = new Rectangle(-20, -15, 40, 30);
        this.hitBox = new Rectangle(-25, -20, 50, 40);
        this.selectBox = new Rectangle(-32, -60, 64, 64);
        this.flickSound = (CoordinateMobAbility)this.registerAbility((MobAbility)new CoordinateMobAbility(){

            protected void run(int x, int y) {
                if (StarfangedDestroyerHead.this.isClient()) {
                    SoundManager.playSound((GameSound)GameResources.magicbolt2, (SoundEffect)SoundEffect.effect((float)x, (float)y).pitch(1.5f).volume(0.5f));
                }
            }
        });
        this.swingSound = (CoordinateMobAbility)this.registerAbility((MobAbility)new CoordinateMobAbility(){

            protected void run(int x, int y) {
                if (StarfangedDestroyerHead.this.isClient()) {
                    SoundManager.playSound((GameSound)GameResources.swing1, (SoundEffect)SoundEffect.effect((float)x, (float)y).pitch(0.8f).volume(1.0f));
                }
            }
        });
    }

    public void setupHealthPacket(PacketWriter writer, boolean isFull) {
        this.scaling.setupHealthPacket(writer, isFull);
        super.setupHealthPacket(writer, isFull);
    }

    public void applyHealthPacket(PacketReader reader, boolean isFull) {
        this.scaling.applyHealthPacket(reader, isFull);
        super.applyHealthPacket(reader, isFull);
    }

    public void setMaxHealth(int maxHealth) {
        super.setMaxHealth(maxHealth);
        if (this.scaling != null) {
            this.scaling.updatedMaxHealth();
        }
    }

    protected void onAppearAbility() {
        super.onAppearAbility();
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.globalEffect().pitch(1.2f));
        }
    }

    protected float getDistToBodyPart(StarfangedDestroyerBody bodyPart, int index, float lastDistance) {
        return lengthPerBodyPart;
    }

    protected StarfangedDestroyerBody createNewBodyPart(int index) {
        StarfangedDestroyerBody bodyPart = index == 69 ? new StarfangedDestroyerTail() : new StarfangedDestroyerBody();
        bodyPart.sharesHitCooldownWithNext = index % 3 < 2;
        boolean bl = bodyPart.relaysBuffsToNext = index % 3 < 2;
        if (index != 0 && index != 68) {
            bodyPart.sprite = new Point(index % 4, 0);
            bodyPart.shadowSprite = 0;
        } else {
            bodyPart.sprite = new Point(4, 0);
            bodyPart.shadowSprite = 1;
        }
        return bodyPart;
    }

    protected void playMoveSound() {
        SoundManager.playSound((GameSound)GameResources.shake, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).falloffDistance(1000));
    }

    public void init() {
        super.init();
        this.ai = new BehaviourTreeAI((Mob)this, new StarfangedDestroyerAI(), (AIMover)new FlyingAIMover());
        if (this.isClient()) {
            SoundManager.playSound((GameSound)GameResources.roar, (SoundEffect)SoundEffect.globalEffect().pitch(1.2f));
        }
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public LootTable getPrivateLootTable() {
        return privateLootTable;
    }

    public GameDamage getCollisionDamage(Mob target) {
        return headCollisionDamage;
    }

    public int getMaxHealth() {
        return super.getMaxHealth() + (int)((float)(this.scaling == null ? 0 : this.scaling.getHealthIncrease()) * this.getMaxHealthModifier());
    }

    public void clientTick() {
        super.clientTick();
        SoundManager.setMusic((GameMusic)DeathriteMod.StarfangedMusic, (SoundManager.MusicPriority)SoundManager.MusicPriority.EVENT, (float)1.5f);
        EventStatusBarManager.registerMobHealthStatusBar((Mob)this);
        BossNearbyBuff.applyAround((Mob)this);
        float healthPerc = (float)this.getHealth() / (float)this.getMaxHealth();
        float mod = Math.abs((float)Math.pow(healthPerc, 0.5) - 1.0f);
        this.setSpeed(120.0f + mod * 90.0f);
    }

    public void serverTick() {
        super.serverTick();
        this.scaling.serverTick();
        BossNearbyBuff.applyAround((Mob)this);
        float healthPerc = (float)this.getHealth() / (float)this.getMaxHealth();
        float mod = Math.abs((float)Math.pow(healthPerc, 0.5) - 1.0f);
        this.setSpeed(120.0f + mod * 90.0f);
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), DeathriteMod.StarfangedDestroyerTexture, GameRandom.globalRandom.nextInt(6), 6, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        if (this.isVisible()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(x) - 48;
            int drawY = camera.getDrawY(y);
            float headAngle = GameMath.fixAngle((float)GameMath.getAngle((Point2D.Float)new Point2D.Float(this.dx, this.dy)));
            WormMobHead.addAngledDrawable(list, (GameSprite)new GameSprite(DeathriteMod.StarfangedDestroyerTexture, 0, 1, 96), (GameTexture)MobRegistry.Textures.swampGuardian_mask, (GameLight)light, (int)((int)this.height), (float)headAngle, (int)drawX, (int)drawY, (int)64);
            this.addShadowDrawables(tileList, level, x, y, light, camera);
        }
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.swampGuardian_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2;
        return shadowTexture.initDraw().sprite(2, 0, res).light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }

    public boolean shouldDrawOnMap() {
        return this.isVisible();
    }

    public void drawOnMap(TickManager tickManager, Client client, int x, int y, double tileScale, Rectangle drawBounds, boolean isMinimap) {
        super.drawOnMap(tickManager, client, x, y, tileScale, drawBounds, isMinimap);
        int drawX = x - 24;
        int drawY = y - 24;
        float headAngle = GameMath.fixAngle((float)GameMath.getAngle((Point2D.Float)new Point2D.Float(this.dx, this.dy)));
        DeathriteMod.StarfangedDestroyerTexture.initDraw().sprite(2, 2, 96).rotate(headAngle + 90.0f, 24, 24).size(48, 48).draw(drawX, drawY);
    }

    public Rectangle drawOnMapBox(double tileScale, boolean isMinimap) {
        return new Rectangle(-15, -15, 30, 30);
    }

    public GameTooltips getMapTooltips() {
        return !this.isVisible() ? null : new StringTooltips(this.getDisplayName() + " " + this.getHealth() + "/" + this.getMaxHealth());
    }

    public Stream<ModifierValue<?>> getDefaultModifiers() {
        return Stream.of(new ModifierValue(BuffModifiers.SLOW, (Object)Float.valueOf(0.0f)).max((Object)Float.valueOf(0.2f)));
    }

    protected void onDeath(Attacker attacker, HashSet<Attacker> attackers) {
        super.onDeath(attacker, attackers);
        attackers.stream().map(Attacker::getFirstPlayerOwner).filter(Objects::nonNull).filter(PlayerMob::isServerClient).map(PlayerMob::getServerClient).distinct().forEach(c -> c.sendChatMessage((GameMessage)new LocalMessage("misc", "bossdefeat", "name", this.getLocalization())));
        if (!this.isDamagedByPlayers) {
            AchievementManager.checkMeAndThisArmyKill((Level)this.getLevel(), attackers);
        }
    }

    static {
        lengthPerBodyPart = 25.0f;
        waveLength = 500.0f;
        MAX_HEALTH = new MaxHealthGetter(40000, 63000, 75000, 93750, 95000);
        privateLootTable = new LootTable(new LootItemInterface[]{uniqueDrops});
        headCollisionDamage = new GameDamage(95.0f);
        bodyCollisionDamage = new GameDamage(75.0f);
        razorDamage = new GameDamage(80.0f);
        totalRazorProjectiles = 500;
    }

    public static class StarfangedDestroyerAI<T extends StarfangedDestroyerHead>
    extends SelectorAINode<T> {
        public StarfangedDestroyerAI() {
            SequenceAINode chaserSequence = new SequenceAINode();
            this.addChild((AINode)chaserSequence);
            chaserSequence.addChild((AINode)new RemoveOnNoTargetNode(100));
            final TargetFinderAINode targetFinder = new TargetFinderAINode<T>(3200){

                public GameAreaStream<? extends Mob> streamPossibleTargets(T mob, Point base, TargetFinderDistance<T> distance) {
                    return TargetFinderAINode.streamPlayers(mob, (Point)base, distance);
                }
            };
            chaserSequence.addChild((AINode)targetFinder);
            targetFinder.moveToAttacker = false;
            ChargingCirclingChaserAINode chaserAI = new ChargingCirclingChaserAINode(500, 40);
            chaserSequence.addChild((AINode)chaserAI);
            chaserSequence.addChild((AINode)new SpawnProjectilesOnHealthLossAINode<T>(totalRazorProjectiles){

                public void shootProjectile(T mob) {
                    WormMobHead.BodyPartTarget t = ((StarfangedDestroyerHead)mob).getRandomTargetFromBodyPart((AINode)this, targetFinder, (m, bp) -> {
                        if (bp.getDistance(m) > 500.0f) {
                            return false;
                        }
                        CollisionFilter collisionFilter = bp.modifyChasingCollisionFilter(new CollisionFilter().mobCollision(), m);
                        return !mob.getLevel().collides((Line2D)new Line2D.Float(m.x, m.y, bp.x, bp.y), collisionFilter);
                    });
                    if (t != null) {
                        if (!WorldEntity.getDebugWorldEntity().isNight()) {
                            ((StarfangedDestroyerBody)t.bodyPart).getLevel().entityManager.projectiles.add((Entity)new ShootingStarProjectile(((StarfangedDestroyerBody)t.bodyPart).getLevel(), (Mob)mob, ((StarfangedDestroyerBody)t.bodyPart).x, ((StarfangedDestroyerBody)t.bodyPart).y, t.target.x, t.target.y, 140.0f, 1750, razorDamage, 50));
                        } else {
                            ((StarfangedDestroyerBody)t.bodyPart).getLevel().entityManager.projectiles.add((Entity)new ShootingStarProjectile(((StarfangedDestroyerBody)t.bodyPart).getLevel(), (Mob)mob, ((StarfangedDestroyerBody)t.bodyPart).x, ((StarfangedDestroyerBody)t.bodyPart).y, t.target.x, t.target.y, 220.0f, 2000, razorDamage, 100));
                        }
                        ((StarfangedDestroyerHead)((Object)mob)).flickSound.runAndSend(((StarfangedDestroyerBody)t.bodyPart).getX(), ((StarfangedDestroyerBody)t.bodyPart).getY());
                    }
                }
            });
            chaserSequence.addChild(new DiveChargeRotationAI(chaserAI));
            this.addChild((AINode)new WandererAINode(0));
        }
    }

    public static class DiveChargeRotationAI<T extends StarfangedDestroyerHead>
    extends AINode<T> {
        private int ticker;
        private final ChargingCirclingChaserAINode<T> chaserAI;

        public DiveChargeRotationAI(ChargingCirclingChaserAINode<T> chaserAI) {
            this.chaserAI = chaserAI;
        }

        protected void onRootSet(AINode<T> root, T mob, Blackboard<T> blackboard) {
            this.ticker = 100;
        }

        public void init(T mob, Blackboard<T> blackboard) {
        }

        public AINodeResult tick(T mob, Blackboard<T> blackboard) {
            Mob target = (Mob)blackboard.getObject(Mob.class, "currentTarget");
            if (target != null) {
                --this.ticker;
                if (this.ticker <= 0) {
                    if (!((StarfangedDestroyerHead)((Object)mob)).dive && !((StarfangedDestroyerHead)((Object)mob)).isUnderground) {
                        ((StarfangedDestroyerHead)((Object)mob)).diveAbility.runAndSend();
                        this.chaserAI.startCircling(mob, blackboard, target, 100);
                        this.ticker = (int)(20.0f * GameRandom.globalRandom.getFloatBetween(2.0f, 3.0f));
                    } else {
                        this.chaserAI.startCharge(mob, blackboard, target);
                        float currentAngle = GameMath.getAngle((Point2D.Float)new Point2D.Float(((StarfangedDestroyerHead)((Object)mob)).x - target.x, ((StarfangedDestroyerHead)((Object)mob)).y - target.y));
                        Point2D.Float dir = GameMath.getAngleDir((float)currentAngle);
                        ((StarfangedDestroyerHead)((Object)mob)).appearAbility.runAndSend(((StarfangedDestroyerHead)((Object)mob)).x, ((StarfangedDestroyerHead)((Object)mob)).y, -dir.x, -dir.y);
                        this.ticker = (int)(20.0f * GameRandom.globalRandom.getFloatBetween(8.0f, 9.0f));
                    }
                }
            }
            return AINodeResult.SUCCESS;
        }
    }
}

