/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Mobs.Bosses.StarfangedDestroyer;

import deathrite.DeathriteMod;
import deathrite.Mobs.Bosses.StarfangedDestroyer.EnragedStarfangedDestroyerHead;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.gameLoop.tickManager.TicksPerSecond;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.ComputedValue;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.WormMobHead;
import necesse.entity.mobs.hostile.bosses.BossWormMobBody;
import necesse.entity.particle.FleshParticle;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class EnragedStarfangedDestroyerBody
extends BossWormMobBody<EnragedStarfangedDestroyerHead, EnragedStarfangedDestroyerBody> {
    public Point sprite = new Point(0, 0);
    public int shadowSprite = 0;
    private TicksPerSecond particleSpawner = TicksPerSecond.ticksPerSecond((int)30);

    public EnragedStarfangedDestroyerBody() {
        super(1000);
        this.isSummoned = true;
        this.collision = new Rectangle(-20, -15, 40, 30);
        this.hitBox = new Rectangle(-25, -20, 50, 40);
        this.selectBox = new Rectangle(-32, -60, 64, 64);
    }

    public GameMessage getLocalization() {
        return new LocalMessage("mob", "enragedstarfangeddestroyer");
    }

    public GameDamage getCollisionDamage(Mob target) {
        return EnragedStarfangedDestroyerHead.bodyCollisionDamage;
    }

    public void clientTick() {
        super.clientTick();
        if (this.isVisible()) {
            this.particleSpawner.gameTick();
            while (this.particleSpawner.shouldTick()) {
                ComputedValue obj = new ComputedValue(() -> this.getLevel().getObject(this.getX() / 32, this.getY() / 32));
                if (!(this.height < 20.0f) || !((GameObject)obj.get()).isWall && !((GameObject)obj.get()).isRock) {
                    if (!(this.height < 0.0f)) continue;
                    this.getLevel().entityManager.addParticle(this.x + GameRandom.globalRandom.floatGaussian() * 15.0f, this.y + GameRandom.globalRandom.floatGaussian() * 10.0f + 5.0f, Particle.GType.COSMETIC).movesConstant(GameRandom.globalRandom.floatGaussian() * 6.0f, GameRandom.globalRandom.floatGaussian() * 3.0f).smokeColor().heightMoves(10.0f, GameRandom.globalRandom.getFloatBetween(30.0f, 40.0f)).lifeTime(200);
                    continue;
                }
                this.getLevel().entityManager.addTopParticle(this.x + GameRandom.globalRandom.floatGaussian() * 15.0f, this.y + GameRandom.globalRandom.floatGaussian() * 10.0f + 5.0f, Particle.GType.COSMETIC).movesConstant(GameRandom.globalRandom.floatGaussian() * 6.0f, GameRandom.globalRandom.floatGaussian() * 3.0f).smokeColor().heightMoves(10.0f, GameRandom.globalRandom.getFloatBetween(30.0f, 40.0f)).lifeTime(200);
            }
        }
    }

    public void spawnDeathParticles(float knockbackX, float knockbackY) {
        if (this.isVisible()) {
            for (int i = 0; i < 4; ++i) {
                this.getLevel().entityManager.addParticle((Particle)new FleshParticle(this.getLevel(), DeathriteMod.StarfangedDestroyerTexture, GameRandom.globalRandom.nextInt(6), 6, 32, this.x, this.y, 20.0f, knockbackX, knockbackY), Particle.GType.IMPORTANT_COSMETIC);
            }
        }
    }

    protected void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        if (this.isVisible()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(x) - 48;
            int drawY = camera.getDrawY(y);
            WormMobHead.addDrawable(list, (GameSprite)new GameSprite(DeathriteMod.StarfangedDestroyerTexture, this.sprite.x, this.sprite.y, 96), (GameTexture)MobRegistry.Textures.swampGuardian_mask, (GameLight)light, (int)((int)this.height), (int)drawX, (int)drawY, (int)64);
            this.addShadowDrawables(tileList, level, x, y, light, camera);
        }
    }

    protected TextureDrawOptions getShadowDrawOptions(int x, int y, GameLight light, GameCamera camera) {
        GameTexture shadowTexture = MobRegistry.Textures.swampGuardian_shadow;
        int res = shadowTexture.getHeight();
        int drawX = camera.getDrawX(x) - res / 2;
        int drawY = camera.getDrawY(y) - res / 2;
        return shadowTexture.initDraw().sprite(this.shadowSprite, 0, res).light(light).pos(drawX, drawY += this.getBobbing(x, y));
    }
}

