/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Xaeron;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.entity.levelEvent.GlaiveShowAttackEvent;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.glaiveToolItem.GlaiveToolItem;
import necesse.inventory.lootTable.presets.GlaiveWeaponsLootTable;
import necesse.level.maps.Level;

public class XaeronGlaive
extends GlaiveToolItem {
    public XaeronGlaive() {
        super(1600, GlaiveWeaponsLootTable.glaiveWeapons);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(550);
        this.attackDamage.setBaseValue(80.0f).setUpgradedValue(1.0f, 85.0f);
        this.attackRange.setBaseValue(225);
        this.knockback.setBaseValue(200);
        this.width = 20.0f;
        this.attackXOffset = 58;
        this.attackYOffset = 58;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        super.showAttack(level, x, y, attackerMob, attackHeight, item, animAttack, seed, mapContent);
        if (level.isClient()) {
            level.entityManager.addLevelEventHidden((LevelEvent)new GlaiveShowAttackEvent((AttackAnimMob)attackerMob, x, y, seed, 10.0f){

                public void tick(float angle) {
                    Point2D.Float angleDir = this.getAngleDir(angle);
                    this.level.entityManager.addParticle(this.attackMob.x + angleDir.x * 75.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y + angleDir.y * 75.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).color(new Color(0, 0, 255)).minDrawLight(150).givesLight(179.0f, 1.0f).lifeTime(400);
                    this.level.entityManager.addParticle(this.attackMob.x - angleDir.x * 75.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y - angleDir.y * 75.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).color(new Color(255, 0, 0)).minDrawLight(150).givesLight(179.0f, 1.0f).lifeTime(400);
                }
            });
        }
    }
}

