/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Xaeron;

import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.XaeronDaggerProjectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.ThrowToolItem;
import necesse.inventory.lootTable.presets.ThrowWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class XaeronDagger
extends ThrowToolItem {
    public XaeronDagger() {
        super(1200, ThrowWeaponsLootTable.throwWeapons);
        this.attackAnimTime.setBaseValue(140);
        this.damageType = DamageTypeRegistry.MELEE;
        this.attackDamage.setBaseValue(70.0f).setUpgradedValue(1.0f, 80.0f);
        this.velocity.setBaseValue(200);
        this.rarity = Item.Rarity.LEGENDARY;
        this.stackSize = 1;
        this.attackRange.setBaseValue(900);
        this.resilienceGain.setBaseValue(0.6f);
        this.itemAttackerProjectileCanHitWidth = 8.0f;
        this.setItemCategory(new String[]{"equipment", "weapons", "meleeweapons"});
        this.setItemCategory(ItemCategory.equipmentManager, new String[]{"weapons", "meleeweapons"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"equipment", "weapons", "meleeweapons"});
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"xaerondaggertip1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"xaerondaggertip2"));
        return tooltips;
    }

    public GameMessage getSettlerCanUseError(HumanMob mob, InventoryItem item) {
        return null;
    }

    public InventoryItem onAttack(Level level, int x, int y, PlayerMob player, int attackHeight, InventoryItem item, PlayerInventorySlot slot, int animAttack, int seed, PacketReader contentReader) {
        int velocity = this.getThrowingVelocity(item, (Mob)player);
        XaeronDaggerProjectile projectile = new XaeronDaggerProjectile(level, (Mob)player, player.x, player.y, x, y, velocity, this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)player));
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        GameRandom random = new GameRandom((long)seed);
        projectile.resetUniqueID(random);
        projectile.moveDist(30.0);
        projectile.setAngle(projectile.getAngle() + (float)random.getIntBetween(-15, 15));
        level.entityManager.projectiles.addHidden((Entity)projectile);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile, player.getServerClient());
        }
        return item;
    }

    public InventoryItem onSettlerAttack(Level level, HumanMob mob, Mob target, int attackHeight, int seed, InventoryItem item) {
        int velocity = this.getProjectileVelocity(item, (Mob)mob);
        Point2D.Float targetPos = Projectile.getPredictedTargetPos((Mob)target, (float)mob.x, (float)mob.y, (float)velocity, (float)-30.0f);
        mob.attackItem((int)targetPos.x, (int)targetPos.y, item);
        GameRandom random = new GameRandom((long)seed);
        XaeronDaggerProjectile projectile = new XaeronDaggerProjectile(level, (Mob)mob, mob.x, mob.y, targetPos.x, targetPos.y, velocity, this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)mob));
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.resetUniqueID(random);
        projectile.moveDist(30.0);
        projectile.setAngle(projectile.getAngle() + (float)random.getIntBetween(-15, 15));
        level.entityManager.projectiles.addHidden((Entity)projectile);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }
        return item;
    }

    public boolean isEnchantable(InventoryItem item) {
        return item.getAmount() >= this.getStackSize();
    }

    public String getIsEnchantableError(InventoryItem item) {
        return item.getAmount() < this.getStackSize() ? Localization.translate((String)"itemtooltip", (String)"enchantfullstack") : super.getIsEnchantableError(item);
    }
}

