/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Xaeron;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.attackHandler.SlimeGreatswordAttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.swordToolItem.greatswordToolItem.GreatswordToolItem;
import necesse.inventory.lootTable.presets.GreatswordWeaponsLootTable;
import necesse.level.maps.Level;

public class CrystalizedXaeronGreatsword
extends GreatswordToolItem {
    public CrystalizedXaeronGreatsword() {
        super(900, GreatswordWeaponsLootTable.greatswordWeapons, CrystalizedXaeronGreatsword.getThreeChargeLevels((int)500, (int)600, (int)700));
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackDamage.setBaseValue(160.0f).setUpgradedValue(1.0f, 185.0f);
        this.attackRange.setBaseValue(120);
        this.knockback.setBaseValue(160);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"slimegreatswordchargetip1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"slimegreatswordchargetip2"));
        return tooltips;
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        attackerMob.startAttackHandler((AttackHandler)new SlimeGreatswordAttackHandler(attackerMob, slot, item, (GreatswordToolItem)this, seed, x, y, this.chargeLevels));
        return item;
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        int timePerFrame = 100;
        int spriteRes = this.attackTexture.getHeight();
        int sprites = this.attackTexture.getWidth() / spriteRes;
        int sprite = GameUtils.getAnim((long)(player == null ? System.currentTimeMillis() : player.getLocalTime()), (int)sprites, (int)(sprites * timePerFrame));
        return new GameSprite(this.attackTexture, sprite, 0, spriteRes);
    }
}

