/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Aethium;

import deathrite.Projectiles.AethiumStaffRidiumBallProjectile;
import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.presets.MagicWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class AethiumStaff
extends MagicProjectileToolItem {
    public AethiumStaff() {
        super(1400, MagicWeaponsLootTable.magicWeapons);
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(600);
        this.attackDamage.setBaseValue(52.0f).setUpgradedValue(1.0f, 65.0f);
        this.knockback.setBaseValue(80);
        this.attackXOffset = 20;
        this.attackYOffset = 20;
        this.velocity.setBaseValue(100);
        this.attackRange.setBaseValue(200);
        this.manaCost.setBaseValue(2.25f).setUpgradedValue(1.0f, 4.5f);
        this.resilienceGain.setBaseValue(2.0f);
        this.itemAttackerProjectileCanHitWidth = 10.0f;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"aethiumstafftip"));
        return tooltips;
    }

    public GameMessage getSettlerCanUseError(HumanMob mob, InventoryItem item) {
        return null;
    }

    public void showAttack(Level level, int x, int y, AttackAnimMob mob, int attackHeight, InventoryItem item, int seed, PacketReader contentReader) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.8f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.0f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, PlayerMob player, int attackHeight, InventoryItem item, PlayerInventorySlot slot, int animAttack, int seed, PacketReader contentReader) {
        AethiumStaffRidiumBallProjectile projectile = new AethiumStaffRidiumBallProjectile(player.x, player.y, x, y, this.getProjectileVelocity(item, (Mob)player), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)player), (Mob)player);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.resetUniqueID(new GameRandom((long)seed));
        level.entityManager.projectiles.addHidden((Entity)projectile);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile, player.getServerClient());
        }
        this.consumeMana((ItemAttackerMob)player, item);
        return item;
    }

    public InventoryItem onSettlerAttack(Level level, HumanMob mob, Mob target, int attackHeight, int seed, InventoryItem item) {
        int velocity = this.getProjectileVelocity(item, (Mob)mob);
        Point2D.Float targetPos = Projectile.getPredictedTargetPos((Mob)target, (float)mob.x, (float)mob.y, (float)velocity, (float)-10.0f);
        mob.attackItem((int)targetPos.x, (int)targetPos.y, item);
        AethiumStaffRidiumBallProjectile projectile = new AethiumStaffRidiumBallProjectile(mob.x, mob.y, targetPos.x, targetPos.y, velocity, this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)mob), (Mob)mob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.resetUniqueID(new GameRandom((long)seed));
        level.entityManager.projectiles.addHidden((Entity)projectile);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile);
        }
        return item;
    }
}

