/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Aethium;

import deathrite.Projectiles.AetherArrowVisualProjectile;
import deathrite.Projectiles.RidiumArrowVisualProjectile;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.inventory.item.toolItem.projectileToolItem.bowProjectileToolItem.BowProjectileToolItem;
import necesse.inventory.lootTable.presets.BowWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class AethiumBow
extends BowProjectileToolItem {
    public AethiumBow() {
        super(1500, BowWeaponsLootTable.bowWeapons);
        this.attackAnimTime.setBaseValue(450);
        this.rarity = Item.Rarity.EPIC;
        this.attackDamage.setBaseValue(44.0f).setUpgradedValue(1.0f, 90.0f);
        this.velocity.setBaseValue(250);
        this.attackRange.setBaseValue(800);
        this.attackXOffset = 12;
        this.attackYOffset = 28;
    }

    public void showAttack(Level level, int x, int y, AttackAnimMob mob, int attackHeight, InventoryItem item, int seed, PacketReader contentReader) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).pitch(1.1f));
        }
    }

    protected void addExtraBowTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"aethiumbowtip"));
    }

    public GameMessage getSettlerCanUseError(HumanMob mob, InventoryItem item) {
        return new LocalMessage("ui", "settlercantuseitem");
    }

    protected void fireProjectiles(Level level, int x, int y, PlayerMob player, InventoryItem item, int seed, ArrowItem arrow, boolean consumeAmmo, PacketReader contentReader) {
        GameRandom random = new GameRandom((long)seed);
        boolean left = (float)x < player.x;
        RidiumArrowVisualProjectile ridiumProjectile = new RidiumArrowVisualProjectile((Mob)player, player.x, player.y, x, y, (float)this.getProjectileVelocity(item, (Mob)player) * arrow.speedMod, this.getAttackRange(item), this.getAttackDamage(item).add((float)arrow.damage, arrow.armorPen, arrow.critChance), this.getKnockback(item, (Attacker)player));
        ridiumProjectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        ridiumProjectile.setAngle(ridiumProjectile.getAngle() + (float)(left ? 10 : -10));
        ridiumProjectile.dropItem = false;
        ridiumProjectile.getUniqueID(random);
        AetherArrowVisualProjectile ridium2Projectile = new AetherArrowVisualProjectile((Mob)player, player.x, player.y, x, y, (float)this.getProjectileVelocity(item, (Mob)player) * arrow.speedMod, this.getAttackRange(item), this.getAttackDamage(item).add((float)arrow.damage, arrow.armorPen, arrow.critChance), this.getKnockback(item, (Attacker)player));
        ridium2Projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        ridium2Projectile.setAngle(ridium2Projectile.getAngle() - (float)(left ? 10 : -10));
        ridium2Projectile.dropItem = false;
        ridium2Projectile.getUniqueID(random);
        RidiumArrowVisualProjectile ridium3Projectile = new RidiumArrowVisualProjectile((Mob)player, player.x, player.y, x, y, (float)this.getProjectileVelocity(item, (Mob)player) * arrow.speedMod, this.getAttackRange(item), this.getAttackDamage(item).add((float)arrow.damage, arrow.armorPen, arrow.critChance), this.getKnockback(item, (Attacker)player));
        ridium3Projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        ridium3Projectile.setAngle(ridium3Projectile.getAngle() + (float)(left ? 5 : -5));
        ridium3Projectile.dropItem = false;
        ridium3Projectile.getUniqueID(random);
        AetherArrowVisualProjectile ridium4Projectile = new AetherArrowVisualProjectile((Mob)player, player.x, player.y, x, y, (float)this.getProjectileVelocity(item, (Mob)player) * arrow.speedMod, this.getAttackRange(item), this.getAttackDamage(item).add((float)arrow.damage, arrow.armorPen, arrow.critChance), this.getKnockback(item, (Attacker)player));
        ridium4Projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        ridium4Projectile.setAngle(ridium4Projectile.getAngle() - (float)(left ? 5 : -5));
        ridium4Projectile.dropItem = false;
        ridium4Projectile.getUniqueID(random);
        level.entityManager.projectiles.addHidden((Entity)ridiumProjectile);
        level.entityManager.projectiles.addHidden((Entity)ridium2Projectile);
        level.entityManager.projectiles.addHidden((Entity)ridium3Projectile);
        level.entityManager.projectiles.addHidden((Entity)ridium4Projectile);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)ridiumProjectile), (RegionPositionGetter)ridiumProjectile, player.getServerClient());
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)ridium2Projectile), (RegionPositionGetter)ridium2Projectile, player.getServerClient());
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)ridium3Projectile), (RegionPositionGetter)ridium3Projectile, player.getServerClient());
            level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)ridium4Projectile), (RegionPositionGetter)ridium4Projectile, player.getServerClient());
        }
    }
}

