/*
 * Decompiled with CFR 0.152.
 */
package deathrite.Items.Weapons.Aether;

import deathrite.Events.WeaponEvents.AetherStaffEvent;
import java.awt.geom.Point2D;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.AncientDredgingStaffEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.presets.MagicWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class AetherStaff
extends MagicProjectileToolItem {
    public AetherStaff() {
        super(1300, MagicWeaponsLootTable.magicWeapons);
        this.rarity = Item.Rarity.RARE;
        this.attackAnimTime.setBaseValue(550);
        this.attackDamage.setBaseValue(57.0f).setUpgradedValue(1.0f, 140.0f);
        this.velocity.setBaseValue(150);
        this.attackXOffset = 14;
        this.attackYOffset = 4;
        this.attackRange.setBaseValue(700);
        this.knockback.setBaseValue(50);
        this.manaCost.setBaseValue(2.5f).setUpgradedValue(1.0f, 4.5f);
        this.itemAttackerProjectileCanHitWidth = 5.0f;
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        super.setDrawAttackRotation(item, drawOptions, attackDirX, attackDirY, attackProgress);
    }

    public GameMessage getSettlerCanUseError(HumanMob mob, InventoryItem item) {
        return null;
    }

    public void showAttack(Level level, int x, int y, AttackAnimMob mob, int attackHeight, InventoryItem item, int seed, PacketReader contentReader) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt3, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).pitch(1.2f));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, PlayerInventorySlot slot, int animAttack, int seed, PacketReader contentReader) {
        int range = this.getAttackRange(item);
        Point2D.Float dir = new Point2D.Float(x - attackerMob.getX(), y - attackerMob.getY());
        AncientDredgingStaffEvent event = new AncientDredgingStaffEvent((Mob)attackerMob, attackerMob.getX(), attackerMob.getY(), new GameRandom((long)seed), GameMath.getAngle((Point2D.Float)dir), this.getAttackDamage(item), this.getResilienceGain(item), (float)this.getProjectileVelocity(item, (Mob)attackerMob), (float)this.getKnockback(item, (Attacker)attackerMob), (float)range);
        attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
        this.consumeMana(attackerMob, item);
        return item;
    }

    public InventoryItem onSettlerAttack(Level level, HumanMob mob, Mob target, int attackHeight, int seed, InventoryItem item) {
        int velocity = this.getProjectileVelocity(item, (Mob)mob);
        Point2D.Float targetPos = Projectile.getPredictedTargetPos((Mob)target, (float)mob.x, (float)mob.y, (float)velocity, (float)-10.0f);
        mob.attackItem((int)targetPos.x, (int)targetPos.y, item);
        int range = this.getAttackRange(item);
        Point2D.Float dir = new Point2D.Float(targetPos.x - (float)mob.getX(), targetPos.y - (float)mob.getY());
        AetherStaffEvent event = new AetherStaffEvent((Mob)mob, mob.getX(), mob.getY(), new GameRandom((long)seed), GameMath.getAngle((Point2D.Float)dir), this.getAttackDamage(item), this.getResilienceGain(item), velocity, this.getKnockback(item, (Attacker)mob), range);
        level.entityManager.addLevelEventHidden((LevelEvent)event);
        if (level.isServer()) {
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event);
        }
        return item;
    }
}

