/*
 * Decompiled with CFR 0.152.
 */
package moveIt;

import moveIt.BackupFileGenerator;
import moveIt.ChangeObjectPacket;
import necesse.engine.GameEvents;
import necesse.engine.events.GameEvent;
import necesse.engine.events.players.ItemPlaceEvent;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.window.GameWindow;
import necesse.entity.Entity;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.gfx.Renderer;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.InputTooltip;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.placeableItem.PlaceableItem;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;

public class MovingBoxItem
extends PlaceableItem
implements ItemInteractAction {
    public MovingBoxItem() {
        super(1, true);
        this.controllerIsTileBasedPlacing = true;
        this.rarity = Item.Rarity.COMMON;
        this.attackXOffset = 8;
        this.attackYOffset = 8;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 30000;
        this.stackSize = 1;
    }

    public boolean canCombineItem(Level level, PlayerMob player, InventoryItem me, InventoryItem them, String purpose) {
        return false;
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        return this.getItemSprite(item, player);
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        int tileX = GameMath.getTileCoordinate((int)x);
        int tileY = GameMath.getTileCoordinate((int)y);
        ObjectEntity entity = level.entityManager.getObjectEntity(tileX, tileY);
        if (level.isProtected(tileX, tileY)) {
            return false;
        }
        if (entity instanceof InventoryObjectEntity) {
            InventoryObjectEntity invEnt = (InventoryObjectEntity)entity;
            if (invEnt.inventory.getAmount(level, attackerMob.getFirstPlayerOwner(), ItemRegistry.getItem((String)"movingBoxPacked"), "box") <= 0) {
                return !(attackerMob.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) > (double)this.getPlaceRange(item, attackerMob));
            }
            return false;
        }
        return false;
    }

    public String canInteractError(Level level, int x, int y, PlayerMob player, InventoryItem item) {
        int tileX = GameMath.getTileCoordinate((int)x);
        int tileY = GameMath.getTileCoordinate((int)y);
        ObjectEntity entity = level.entityManager.getObjectEntity(tileX, tileY);
        if (level.isProtected(tileX, tileY)) {
            return "protected";
        }
        if (entity instanceof InventoryObjectEntity) {
            InventoryObjectEntity invEnt = (InventoryObjectEntity)entity;
            if (invEnt.inventory.getAmount(level, player, ItemRegistry.getItem((String)"movingBoxPacked"), "box") <= 0) {
                return player.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) > (double)this.getPlaceRange(item, (ItemAttackerMob)player) ? "outofrange" : null;
            }
            return "chest";
        }
        return "blocked";
    }

    public boolean overridesObjectInteract(Level level, PlayerMob player, InventoryItem item) {
        return true;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            ObjectEntity entity;
            int tileX = GameMath.getTileCoordinate((int)x);
            int tileY = GameMath.getTileCoordinate((int)y);
            if (level.isServer() && !level.isProtected && (entity = level.entityManager.getObjectEntity(tileX, tileY)) instanceof InventoryObjectEntity) {
                InventoryObjectEntity invEnt = (InventoryObjectEntity)entity;
                if (invEnt.inventory.getAmount(level, attackerMob.getFirstPlayerOwner(), ItemRegistry.getItem((String)"movingBoxPacked"), "box") <= 0) {
                    ItemRegistry.getItem((String)invEnt.getObject().getObjectItem().getStringID());
                    int slots = invEnt.slots;
                    Item storageCrateItem = ItemRegistry.getItem((String)"movingBoxPacked");
                    InventoryItem storageCrateInvItem = new InventoryItem(storageCrateItem, 1);
                    storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setString("objectItem", invEnt.getObject().getObjectItem().getStringID()));
                    storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setString("objectName", invEnt.getInventoryName().translate()));
                    storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setInt("slots", slots));
                    for (int i = 0; i <= slots; ++i) {
                        if (invEnt.inventory.isSlotClear(i)) continue;
                        storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setString("slot" + i + "Item", invEnt.inventory.getItemStringID(i)));
                        storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setInt("slot" + i + "Amount", invEnt.inventory.getAmount(i)));
                        storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setInt("slot" + i + "GNDSize", invEnt.inventory.getItem(i).getGndData().getMapSize()));
                        if (invEnt.inventory.getItem(i).getGndData().getMapSize() <= 0) continue;
                        Object[] keys = invEnt.inventory.getItem(i).getGndData().getKeySet().toArray();
                        for (int j = 0; j < invEnt.inventory.getItem(i).getGndData().getKeySet().size(); ++j) {
                            String key = keys[j].toString();
                            storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setInt("slot" + i + "GNDKey" + j, ((Integer)keys[j]).intValue()));
                            storageCrateInvItem.setGndData(storageCrateInvItem.getGndData().setItem("slot" + i + "GNDData" + j, invEnt.inventory.getItem(i).getGndData().getItem(key)));
                        }
                    }
                    level.entityManager.pickups.add((Entity)new ItemPickupEntity(level, storageCrateInvItem, (float)x, (float)y, 0.0f, 0.0f));
                    level.setObject(tileX, tileY, 0);
                    BackupFileGenerator.generateNewFile(tileX, tileY, storageCrateInvItem);
                    level.getServer().network.sendToAllClients((Packet)new ChangeObjectPacket(tileX, tileY, true, level.getObject(tileX, tileY), -1, storageCrateInvItem, attackerMob.buffManager.hasBuff("MovingBoxItemOverride"), attackerMob.buffManager.hasBuff("MovingBoxChestOverride"), attackerMob.getFirstPlayerOwner().getPlayerSlot()));
                    attackerMob.getFirstPlayerOwner().getInv().removeItems((Item)this, 1, true, true, true, true, "used");
                }
            }
        }
        return item;
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, InventoryItem item, GNDItemMap mapContent) {
        return "blocked";
    }

    public void setupAttackMapContent(GNDItemMap map, Level level, int x, int y, ItemAttackerMob attackerMob, int seed, InventoryItem item) {
        super.setupAttackMapContent(map, level, x, y, attackerMob, seed, item);
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        int tileX = GameMath.getTileCoordinate((int)x);
        int tileY = GameMath.getTileCoordinate((int)y);
        ItemPlaceEvent event = new ItemPlaceEvent(level, tileX, tileY, player, item);
        GameEvents.triggerEvent((GameEvent)event);
        return item;
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxitemtip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxitemtip2"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxitemtip3"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxitemtip4"));
        return tooltips;
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        drawOptions.swingRotation(attackProgress);
    }

    public String canAttack(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return null;
    }

    public void drawPlacePreview(Level level, int x, int y, GameCamera camera, PlayerMob player, InventoryItem item, PlayerInventorySlot slot) {
    }

    public void onMouseHoverTile(InventoryItem item, GameCamera camera, PlayerMob perspective, int mouseX, int mouseY, TilePosition pos, boolean isDebug) {
        String interactError = this.canInteractError(pos.level, mouseX, mouseY, perspective, item);
        if (interactError == null) {
            Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
            GameTooltipManager.addTooltip((GameTooltips)new InputTooltip(Control.MOUSE2, Localization.translate((String)"controls", (String)"pickup")), (TooltipLocation)TooltipLocation.INTERACT_FOCUS);
        }
    }
}

