/*
 * Decompiled with CFR 0.152.
 */
package moveIt;

import moveIt.ChangeObjectPacket;
import moveIt.MovingBoxPickupEntity;
import necesse.engine.GameEvents;
import necesse.engine.events.GameEvent;
import necesse.engine.events.players.ItemPlaceEvent;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.window.GameWindow;
import necesse.entity.mobs.MaskShaderOptions;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.gfx.Renderer;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.InputTooltip;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.inventory.InventoryItem;
import necesse.inventory.PlayerInventorySlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.placeableItem.PlaceableItem;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;
import necesse.level.maps.light.GameLight;

public class MovingBoxChest
extends PlaceableItem
implements ItemInteractAction {
    public MovingBoxChest() {
        super(1, true);
        this.controllerIsTileBasedPlacing = true;
        this.rarity = Item.Rarity.COMMON;
        this.attackXOffset = 8;
        this.attackYOffset = 8;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 90000;
        this.stackSize = 1;
    }

    public boolean canCombineItem(Level level, PlayerMob player, InventoryItem me, InventoryItem them, String purpose) {
        return false;
    }

    public boolean holdItemInFrontOfArms(InventoryItem item, PlayerMob player, int spriteX, int spriteY, int drawX, int drawY, int width, int height, boolean mirrorX, boolean mirrorY, GameLight light, float alpha, MaskShaderOptions mask) {
        return true;
    }

    public String canAttack(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return null;
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        return this.getItemSprite(item, player);
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        int tileY;
        int tileX = GameMath.getTileCoordinate((int)x);
        if (level.isProtected(tileX, tileY = GameMath.getTileCoordinate((int)y))) {
            return false;
        }
        if (attackerMob.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) < (double)this.getPlaceRange(item, attackerMob)) {
            return level.getObject(tileX, tileY).getID() == 0;
        }
        return false;
    }

    public String canInteractError(Level level, int x, int y, PlayerMob player, InventoryItem item) {
        int tileY;
        int tileX = GameMath.getTileCoordinate((int)x);
        if (level.getObject(tileX, tileY = GameMath.getTileCoordinate((int)y)).getID() == 0 && player.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) < (double)this.getPlaceRange(item, (ItemAttackerMob)player)) {
            return null;
        }
        if (level.isProtected(tileX, tileY)) {
            return "protected";
        }
        return "blocked";
    }

    public boolean overridesObjectInteract(Level level, PlayerMob player, InventoryItem item) {
        return false;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            int tileX = GameMath.getTileCoordinate((int)x);
            int tileY = GameMath.getTileCoordinate((int)y);
            if (!level.isServer()) {
                boolean modAbort = false;
                if (level.getObject(tileX, tileY).getID() == 0) {
                    if (ObjectRegistry.getObjectID((String)item.getGndData().getString("objectItem")) != -1 || attackerMob.buffManager.hasBuff("MovingBoxChestOverride")) {
                        if (attackerMob.buffManager.hasBuff("MovingBoxChestOverride") && ObjectRegistry.getObjectID((String)item.getGndData().getString("objectItem")) == -1) {
                            level.setObject(tileX, tileY, ObjectRegistry.getObjectID((String)"storagebox"), attackerMob.getDir());
                        } else {
                            level.setObject(tileX, tileY, ObjectRegistry.getObjectID((String)item.getGndData().getString("objectItem")), attackerMob.getDir());
                        }
                        ObjectEntity objEnt = level.entityManager.getObjectEntity(tileX, tileY);
                        if (objEnt instanceof InventoryObjectEntity) {
                            InventoryObjectEntity invEnt = (InventoryObjectEntity)objEnt;
                            invEnt.setInventoryName(item.getGndData().getString("objectName", invEnt.getInventoryName().toString()));
                            int slots = invEnt.slots;
                            for (int i = 0; i <= slots; ++i) {
                                if (item.getGndData().getString("slot" + i + "Item").isEmpty()) continue;
                                if (ItemRegistry.getItem((String)item.getGndData().getString("slot" + i + "Item")) != null) {
                                    InventoryItem invItem = new InventoryItem(ItemRegistry.getItem((String)item.getGndData().getString("slot" + i + "Item")), item.getGndData().getInt("slot" + i + "Amount"));
                                    if (item.getGndData().getInt("slot" + i + "GNDSize") > 0) {
                                        for (int j = 0; j < item.getGndData().getInt("slot" + i + "GNDSize"); ++j) {
                                            int key = item.getGndData().getInt("slot" + i + "GNDKey" + j);
                                            invItem.setGndData(invItem.getGndData().setItem(key, item.getGndData().getItem("slot" + i + "GNDData" + j)));
                                        }
                                    }
                                    invEnt.inventory.setItem(i, invItem);
                                    continue;
                                }
                                System.err.println("Unloaded mod item found!");
                                modAbort = true;
                                if (level.isServer()) continue;
                                attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#FF0000WARNING: Mod item found. Item id: \u00a7#FFFFFF" + item.getGndData().getString("slot" + i + "Item"));
                            }
                            if (!modAbort || attackerMob.buffManager.hasBuff("MovingBoxItemOverride")) {
                                attackerMob.buffManager.removeBuff("MovingBoxSlow", true);
                                attackerMob.getFirstPlayerOwner().getClient().getPlayer().getInv().removeItems(item.item, 1, true, true, true, true, "used");
                                attackerMob.getFirstPlayerOwner().getClient().network.sendPacket((Packet)new ChangeObjectPacket(tileX, tileY, false, level.getObject(tileX, tileY), attackerMob.getDir(), item, attackerMob.buffManager.hasBuff("MovingBoxItemOverride"), attackerMob.buffManager.hasBuff("MovingBoxChestOverride"), attackerMob.getFirstPlayerOwner().getPlayerSlot()));
                            } else {
                                level.setObject(tileX, tileY, 0);
                                if (!level.isServer()) {
                                    attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#F2800DChest placement aborted due to mod item inside.");
                                    attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#F2800DUse \"/safetyoverride item\" to override abort.");
                                }
                            }
                        }
                    } else if (!level.isServer()) {
                        attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#FF0000WARNING: Mod chest found. Chest id: \u00a7#FFFFFF" + item.getGndData().getString("objectItem"));
                        attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#F2800DChest placement aborted due to mod chest.");
                        attackerMob.getFirstPlayerOwner().getClient().chat.addMessage("\u00a7#F2800DUse \"/safetyoverride chest\" to override abort.");
                    }
                }
            }
        }
        return item;
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, InventoryItem item, GNDItemMap mapContent) {
        int tileY;
        int tileX = GameMath.getTileCoordinate((int)x);
        if (level.getObject(tileX, tileY = GameMath.getTileCoordinate((int)y)).getID() == 0 && player.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) < (double)this.getPlaceRange(item, (ItemAttackerMob)player)) {
            return null;
        }
        if (level.isProtected(tileX, tileY)) {
            return "protected";
        }
        return "blocked";
    }

    public void setupAttackMapContent(GNDItemMap map, Level level, int x, int y, ItemAttackerMob attackerMob, int seed, InventoryItem item) {
        super.setupAttackMapContent(map, level, x, y, attackerMob, seed, item);
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        int tileX = GameMath.getTileCoordinate((int)x);
        int tileY = GameMath.getTileCoordinate((int)y);
        ItemPlaceEvent event = new ItemPlaceEvent(level, tileX, tileY, player, item);
        GameEvents.triggerEvent((GameEvent)event);
        return item;
    }

    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        super.draw(item, perspective, x, y, inInventory);
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxchesttip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxchesttip2"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"movingboxchestnametip", (String)"key", (String)item.getGndData().getString("objectName")));
        return tooltips;
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        drawOptions.swingRotation(attackProgress);
    }

    public void drawPlacePreview(Level level, int x, int y, GameCamera camera, PlayerMob player, InventoryItem item, PlayerInventorySlot slot) {
        int tileX = GameMath.getTileCoordinate((int)x);
        int tileY = GameMath.getTileCoordinate((int)y);
        if (this.canPlace(level, x, y, player, item, null) == null && ItemRegistry.getItem((String)item.getGndData().getString("objectItem")) != null) {
            ObjectRegistry.getObject((String)item.getGndData().getString("objectItem")).drawPreview(level, tileX, tileY, player.getDir(), 0.5f, player, camera);
        }
    }

    public void onMouseHoverTile(InventoryItem item, GameCamera camera, PlayerMob perspective, int mouseX, int mouseY, TilePosition pos, boolean isDebug) {
        super.onMouseHoverTile(item, camera, perspective, mouseX, mouseY, pos, isDebug);
        String interactError = this.canInteractError(pos.level, mouseX, mouseY, perspective, item);
        if (interactError == null) {
            Renderer.setCursor((GameWindow.CURSOR)GameWindow.CURSOR.INTERACT);
            GameTooltipManager.addTooltip((GameTooltips)new InputTooltip(Control.MOUSE2, Localization.translate((String)"controls", (String)"unpack")), (TooltipLocation)TooltipLocation.INTERACT_FOCUS);
        }
    }

    public ItemPickupEntity getPickupEntity(Level level, InventoryItem item, float x, float y, float dx, float dy) {
        return new MovingBoxPickupEntity(level, item, x, y, dx, dy);
    }
}

