/*
 * Decompiled with CFR 0.152.
 */
package moveIt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import necesse.engine.GlobalData;
import necesse.inventory.InventoryItem;

public class BackupFileGenerator {
    static File modDirectory = new File(GlobalData.appDataPath() + "cfg/mods/moveit/");
    static File backupFile;

    public static File getModSavesPath() {
        if (!modDirectory.exists()) {
            modDirectory.mkdir();
        }
        return modDirectory;
    }

    public static File generateNewFile(int tileX, int tileY, InventoryItem item) {
        backupFile = new File(BackupFileGenerator.getModSavesPath().getPath() + "/" + tileX + "_" + tileY + "_" + LocalDateTime.now().getYear() + "_" + LocalDateTime.now().getMonth() + "_" + LocalDateTime.now().getDayOfMonth() + "_" + LocalDateTime.now().getHour() + "_" + LocalDateTime.now().getMinute() + "_" + LocalDateTime.now().getSecond() + ".dat");
        try {
            FileWriter generateData = new FileWriter(backupFile);
            generateData.write(item.getGndData().toString());
            generateData.close();
        }
        catch (IOException e) {
            System.err.println("Error generating backup file.");
            e.printStackTrace();
        }
        BackupFileGenerator.purgeOldFiles();
        return backupFile;
    }

    public static void purgeOldFiles() {
        if (modDirectory.exists() && Objects.requireNonNull(modDirectory.listFiles()).length > 50) {
            long lowestTime = 0L;
            File lowestFile = null;
            Iterator files = Arrays.stream(Objects.requireNonNull(modDirectory.listFiles())).iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                if (lowestTime == 0L) {
                    lowestTime = file.lastModified();
                    lowestFile = file;
                    continue;
                }
                if (file.lastModified() >= lowestTime) continue;
                lowestTime = file.lastModified();
                lowestFile = file;
            }
            lowestFile.delete();
        }
    }
}

