/*
 * Decompiled with CFR 0.152.
 */
package endlesspotions;

import endlesspotions.foods.RegisterFoods;
import endlesspotions.objects.ImprovedBannerItem;
import endlesspotions.objects.ImprovedCampfire;
import endlesspotions.potions.EndlessHealthPotion;
import endlesspotions.potions.EndlessManaPotion;
import endlesspotions.potions.EndlessPotion;
import endlesspotions.potions.GreaterEndlessPotion;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.inventory.item.Item;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.level.gameObject.GameObject;

@ModEntry
public class EndlessPotions {
    public static int foodBuffDuration = 30000;
    public static int potionsBuffDuration = 30000;
    public static int bannerRangeMultiplier = 5;
    String[] basicPotions = new String[]{"speedpotion", "healthregenpotion", "resistancepotion", "battlepotion", "attackspeedpotion", "manaregenpotion", "accuracypotion", "rapidpotion", "fishingpotion", "miningpotion", "buildingpotion"};
    String[] otherPotions = new String[]{"knockbackpotion", "thornspotion", "fireresistancepotion", "invisibilitypotion", "spelunkerpotion", "treasurepotion", "passivepotion", "strengthpotion", "rangerpotion", "wisdompotion", "minionpotion", "webpotion"};

    public void init() {
        RegisterFoods.register();
        ObjectRegistry.registerObject((String)"improvedcampfire", (GameObject)new ImprovedCampfire(), (float)10.0f, (boolean)true);
        ItemRegistry.registerItem((String)"improvedbannerofspeed", (Item)new ImprovedBannerItem(Item.Rarity.LEGENDARY, 480 * bannerRangeMultiplier, m -> BuffRegistry.Banners.SPEED), (float)200.0f, (boolean)true);
        ItemRegistry.registerItem((String)"improvedbannerofdamage", (Item)new ImprovedBannerItem(Item.Rarity.LEGENDARY, 480 * bannerRangeMultiplier, m -> BuffRegistry.Banners.DAMAGE), (float)200.0f, (boolean)true);
        ItemRegistry.registerItem((String)"improvedbannerofsummonspeed", (Item)new ImprovedBannerItem(Item.Rarity.LEGENDARY, 480 * bannerRangeMultiplier, m -> BuffRegistry.Banners.SUMMON_SPEED), (float)200.0f, (boolean)true);
        ItemRegistry.registerItem((String)"improvedbannerofdefense", (Item)new ImprovedBannerItem(Item.Rarity.LEGENDARY, 480 * bannerRangeMultiplier, m -> BuffRegistry.Banners.DEFENSE), (float)200.0f, (boolean)true);
        for (String s : this.basicPotions) {
            ItemRegistry.registerItem((String)("endless" + s), (Item)new EndlessPotion(s), (float)0.0f, (boolean)true);
            ItemRegistry.registerItem((String)("endlessgreater" + s), (Item)new GreaterEndlessPotion(s), (float)0.0f, (boolean)true);
        }
        for (String s : this.otherPotions) {
            ItemRegistry.registerItem((String)("endless" + s), (Item)new EndlessPotion(s), (float)0.0f, (boolean)true);
        }
        ItemRegistry.registerItem((String)"endlesshealthpotion", (Item)new EndlessHealthPotion(Item.Rarity.LEGENDARY, 50, 0.1f), (float)0.0f, (boolean)true);
        ItemRegistry.registerItem((String)"endlessgreaterhealthpotion", (Item)new EndlessHealthPotion(Item.Rarity.LEGENDARY, 100, 0.2f), (float)0.0f, (boolean)true);
        ItemRegistry.registerItem((String)"endlesssuperiorhealthpotion", (Item)new EndlessHealthPotion(Item.Rarity.LEGENDARY, 150, 0.3f), (float)0.0f, (boolean)true);
        ItemRegistry.registerItem((String)"endlessmanapotion", (Item)new EndlessManaPotion(Item.Rarity.LEGENDARY, 50), (float)0.0f, (boolean)true);
        ItemRegistry.registerItem((String)"endlessgreatermanapotion", (Item)new EndlessManaPotion(Item.Rarity.LEGENDARY, 150), (float)0.0f, (boolean)true);
        ItemRegistry.registerItem((String)"endlesssuperiormanapotion", (Item)new EndlessManaPotion(Item.Rarity.LEGENDARY, 300), (float)0.0f, (boolean)true);
    }

    public void postInit() {
        for (String s : this.basicPotions) {
            Recipes.registerModRecipe((Recipe)new Recipe("endless" + s, 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient(s, 15)}));
            Recipes.registerModRecipe((Recipe)new Recipe("endlessgreater" + s, 1, RecipeTechRegistry.FALLEN_ALCHEMY, new Ingredient[]{new Ingredient("endless" + s, 1), new Ingredient("alchemyshard", 60)}));
        }
        for (String s : this.otherPotions) {
            Recipes.registerModRecipe((Recipe)new Recipe("endless" + s, 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient(s, 15)}));
        }
        Recipes.registerModRecipe((Recipe)new Recipe("endlesshealthpotion", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("healthpotion", 50)}));
        Recipes.registerModRecipe((Recipe)new Recipe("endlessgreaterhealthpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, new Ingredient[]{new Ingredient("endlesshealthpotion", 1), new Ingredient("caveglow", 75)}));
        Recipes.registerModRecipe((Recipe)new Recipe("endlesssuperiorhealthpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, new Ingredient[]{new Ingredient("endlessgreaterhealthpotion", 1), new Ingredient("alchemyshard", 100)}));
        Recipes.registerModRecipe((Recipe)new Recipe("endlessmanapotion", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("manapotion", 50)}));
        Recipes.registerModRecipe((Recipe)new Recipe("endlessgreatermanapotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, new Ingredient[]{new Ingredient("endlessmanapotion", 1), new Ingredient("caveglow", 75)}));
        Recipes.registerModRecipe((Recipe)new Recipe("endlesssuperiormanapotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, new Ingredient[]{new Ingredient("endlessgreatermanapotion", 1), new Ingredient("alchemyshard", 100)}));
        Recipes.registerModRecipe((Recipe)new Recipe("improvedbannerofspeed", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("bannerofspeed", 3)}));
        Recipes.registerModRecipe((Recipe)new Recipe("improvedbannerofdamage", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("bannerofdamage", 3)}));
        Recipes.registerModRecipe((Recipe)new Recipe("improvedbannerofsummonspeed", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("bannerofsummonspeed", 3)}));
        Recipes.registerModRecipe((Recipe)new Recipe("improvedbannerofdefense", 1, RecipeTechRegistry.ALCHEMY, new Ingredient[]{new Ingredient("bannerofdefense", 3)}));
        for (String id : RegisterFoods.roastedFoods) {
            Recipes.registerModRecipe((Recipe)new Recipe(id, 1, RecipeTechRegistry.ROASTING_STATION, new Ingredient[]{new Ingredient(id.replace("endless", ""), 15)}));
        }
        for (String id : RegisterFoods.fineFoods) {
            Recipes.registerModRecipe((Recipe)new Recipe(id, 1, RecipeTechRegistry.COOKING_POT, new Ingredient[]{new Ingredient(id.replace("endless", ""), 15)}));
        }
        for (String id : RegisterFoods.gourmetFoods) {
            Recipes.registerModRecipe((Recipe)new Recipe(id, 1, RecipeTechRegistry.COOKING_POT, new Ingredient[]{new Ingredient(id.replace("endless", ""), 15)}));
        }
        Recipes.registerModRecipe((Recipe)new Recipe("improvedcampfire", 1, RecipeTechRegistry.WORKSTATION, new Ingredient[]{new Ingredient("campfire", 10)}));
    }
}

