/*
 * Decompiled with CFR 0.152.
 */
package engineer.patches.wrench;

import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.placeableItem.WrenchPlaceableItem;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=WrenchPlaceableItem.class, name="canInteractError", arguments={Level.class, int.class, int.class, PlayerMob.class, InventoryItem.class})
public class WrenchInteractErrorPatch {
    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    static boolean onEnter() {
        return true;
    }

    @Advice.OnMethodExit
    static String onExit(@Advice.This WrenchPlaceableItem wrench, @Advice.Argument(value=0) Level level, @Advice.Argument(value=1) int x, @Advice.Argument(value=2) int y, @Advice.Argument(value=3) PlayerMob player, @Advice.Argument(value=4) InventoryItem item, @Advice.Return(readOnly=false) String error) {
        int tileX = x / 32;
        int tileY = y / 32;
        if (level.isProtected(tileX, tileY)) {
            error = "protected";
            return error;
        }
        if (level.objectLayer.getObject(0, tileX, tileY) == null) {
            error = "blank";
            return error;
        }
        if (!level.logicLayer.hasGate(tileX, tileY) && !level.objectLayer.getObject(0, tileX, tileY).canInteract(level, tileX, tileY, player)) {
            error = "blank";
            return error;
        }
        if (level.getObject(tileX, tileY).canInteract(level, tileX, tileY, player) && !level.logicLayer.hasGate(tileX, tileY)) {
            error = "interactable";
            return error;
        }
        error = player.getPositionPoint().distance(tileX * 32 + 16, tileY * 32 + 16) > (double)wrench.getPlaceRange(item, (ItemAttackerMob)player) ? "outofrange" : null;
        return error;
    }
}

