/*
 * Decompiled with CFR 0.152.
 */
package engineer.objects.vanilla;

import engineer.objects.vanilla.NewArrowObjectEntity;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.WallObject;
import necesse.level.gameObject.WallTrapObject;
import necesse.level.maps.Level;

public class WallArrowTrapObject
extends WallTrapObject {
    public WallArrowTrapObject(WallObject wallObject) {
        super(wallObject, "arrowtrap");
        this.addGlobalIngredient(new String[]{"anyarrowtrap"});
    }

    public WallArrowTrapObject(WallObject wallObject, int toolTier, ToolType toolType) {
        super(wallObject, "arrowtrap", (float)toolTier, toolType);
    }

    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new NewArrowObjectEntity(level, x, y);
    }

    public boolean canInteract(Level level, int x, int y, PlayerMob player) {
        ObjectEntity ent = level.entityManager.getObjectEntity(x, y);
        if (ent != null && !level.isTrialRoom) {
            return !((NewArrowObjectEntity)ent).isInUse();
        }
        return false;
    }

    public void interact(Level level, int x, int y, PlayerMob player) {
        ObjectEntity ent;
        if (level.isServer()) {
            // empty if block
        }
        if (level.isClient() && (ent = level.entityManager.getObjectEntity(x, y)) != null) {
            ((NewArrowObjectEntity)ent).firstSaveSetup();
        }
    }

    public void onWireUpdate(Level level, int layerID, int tileX, int tileY, int wireID, boolean active) {
        ObjectEntity ent;
        if (active && (ent = level.entityManager.getObjectEntity(tileX, tileY)) != null) {
            ((NewArrowObjectEntity)ent).triggerTrap(wireID, level.getObjectRotation(tileX, tileY));
        }
    }
}

