/*
 * Decompiled with CFR 0.152.
 */
package engineer.objects.vanilla;

import java.awt.Color;
import java.awt.Point;
import java.io.FileNotFoundException;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.MergeFunction;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.MaskedPressurePlateObject;
import necesse.level.maps.Level;

public class TileMaskedPressurePlateObject
extends MaskedPressurePlateObject {
    protected String maskTextureName;
    protected String tileTextureName;
    public GameTexture texture;

    public TileMaskedPressurePlateObject(String maskTextureName, String tileTextureName, Color mapColor) {
        super(maskTextureName, tileTextureName, mapColor);
    }

    public ListGameTooltips getItemTooltips(InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"placetippath"));
        return tooltips;
    }

    public GameTexture generateItemTexture() {
        GameTexture tileTexture;
        super.loadTextures();
        this.texture = new GameTexture(GameTexture.fromFile((String)("objects/" + this.getStringID()), (boolean)true));
        Point tileSprite = new Point(0, 0);
        try {
            tileTexture = GameTexture.fromFileRaw((String)("tiles/" + this.tileTextureName + "_splat"), (boolean)true);
            tileSprite = new Point(3, 0);
        }
        catch (FileNotFoundException var4) {
            tileTexture = GameTexture.fromFile((String)("tiles/" + this.tileTextureName), (boolean)true);
        }
        MergeFunction mergeFunction = (currentColor, mergeColor) -> currentColor.equals(Color.WHITE) ? mergeColor : currentColor;
        this.texture.merge(tileTexture, 0, 0, tileSprite.x * 32, tileSprite.y * 32 + 2, 32, 30, mergeFunction);
        this.texture.merge(tileTexture, 32, 0, tileSprite.x * 32, tileSprite.y * 32, 32, 32, mergeFunction);
        return new GameTexture(this.texture, 0, 0, 32);
    }

    public boolean canPlaceOn(Level level, int layerID, int x, int y, GameObject other) {
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("stonepathtile") && this.idData.getStringID().equalsIgnoreCase("stonepathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("sandstonepathtile") && this.idData.getStringID().equalsIgnoreCase("sandstonepathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("woodpathtile") && this.idData.getStringID().equalsIgnoreCase("woodpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("spidercastlecarpet") && this.idData.getStringID().equalsIgnoreCase("spidercastlecarpetpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("dawnpath") && this.idData.getStringID().equalsIgnoreCase("dawnpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("lavapath") && this.idData.getStringID().equalsIgnoreCase("lavapathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("moonpath") && this.idData.getStringID().equalsIgnoreCase("moonpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("swampstonepath") && this.idData.getStringID().equalsIgnoreCase("swampstonepathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("cryptpath") && this.idData.getStringID().equalsIgnoreCase("cryptpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("cryptpath") && this.idData.getStringID().equalsIgnoreCase("cryptpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("darkmoonpath") && this.idData.getStringID().equalsIgnoreCase("darkmoonpathpressureplate")) {
            return true;
        }
        if (level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("darkfullmoonpath") && this.idData.getStringID().equalsIgnoreCase("darkfullmoonpathpressureplate")) {
            return true;
        }
        return level.getTile((int)x, (int)y).idData.getStringID().equalsIgnoreCase("swampstonepathtile") && this.idData.getStringID().equalsIgnoreCase("swampstonepathpressureplate");
    }
}

