/*
 * Decompiled with CFR 0.152.
 */
package engineer.objects.vanilla;

import engineer.packets.ArrowTrapInventoryPacket;
import java.awt.Point;
import java.util.ArrayList;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketTrapTriggered;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.objectEntity.interfaces.OEUsers;
import necesse.entity.projectile.Projectile;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryFilter;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.level.maps.Level;
import necesse.level.maps.presets.PresetRotation;

public class NewArrowObjectEntity
extends InventoryObjectEntity {
    public long cooldown = 1000L;
    private long startCooldownTime = 0L;
    public int itemID = 0;
    public int itemAmount = 0;
    public final Inventory inventory;
    public final int slots = 1;
    private boolean interactedWith;
    public final OEUsers.Users users = this.constructUsersObject(2000L);

    public NewArrowObjectEntity(final Level level, int x, int y) {
        super(level, x, y, 1);
        this.shouldSave = false;
        this.inventory = new Inventory(1){

            public void updateSlot(int slot) {
                super.updateSlot(slot);
                NewArrowObjectEntity.this.onInventorySlotUpdated(slot);
                if (level.isLoadingComplete()) {
                    NewArrowObjectEntity.this.triggerInteracted();
                }
            }
        };
        this.inventory.filter = new InventoryFilter(){

            public boolean isItemValid(int slot, InventoryItem item) {
                return NewArrowObjectEntity.this.isItemValid(slot, item);
            }

            public int getItemStackLimit(int slot, InventoryItem item) {
                return NewArrowObjectEntity.this.getItemStackLimit(slot, item);
            }
        };
        if (level != null && !level.isLoadingComplete()) {
            this.interactedWith = false;
            this.inventory.spoilRateModifier = -1415.0f;
        } else {
            this.interactedWith = true;
        }
    }

    public boolean shouldSave() {
        return true;
    }

    public void addSaveData(SaveData save) {
        save.addInt("itemID", this.itemID);
        save.addInt("itemAmount", this.itemAmount);
    }

    public void applyLoadData(LoadData save) {
        this.itemID = save.getInt("itemID");
        this.itemAmount = save.getInt("itemAmount");
        this.firstSaveSetup();
    }

    public void addPresetSaveData(SaveData save) {
        this.addSaveData(save);
    }

    public void firstSaveSetup() {
        if (this.isServer()) {
            this.inventory.clearSlot(0);
            this.inventory.setItem(0, new InventoryItem(ItemRegistry.getItem((int)this.itemID), this.itemAmount), true);
        } else {
            this.inventory.setItem(0, new InventoryItem(ItemRegistry.getItem((int)this.itemID), this.itemAmount), true);
        }
    }

    public void applyPresetLoadData(LoadData save, boolean mirrorX, boolean mirrorY, PresetRotation rotation) {
        this.applyLoadData(save);
    }

    public void setupContentPacket(PacketWriter writer) {
        writer.putNextInt(this.itemID);
        writer.putNextInt(this.itemAmount);
    }

    public void applyContentPacket(PacketReader reader) {
        this.itemID = reader.getNextInt();
        this.itemAmount = reader.getNextInt();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean isItemValid(int slot, InventoryItem item) {
        return item.item.getStringID().contains("arrow");
    }

    public int getItemStackLimit(int slot, InventoryItem item) {
        return item == null ? Integer.MAX_VALUE : item.itemStackSize();
    }

    public ArrayList<InventoryItem> getDroppedItems() {
        ArrayList<InventoryItem> list = new ArrayList<InventoryItem>();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.isSlotClear(i)) continue;
            list.add(this.inventory.getItem(i));
        }
        return list;
    }

    protected void onInventorySlotUpdated(int slot) {
        if (!this.isServer()) {
            if (this.inventory.getItem(slot) != null) {
                if (this.itemID != this.inventory.getItem((int)slot).item.getID() || this.itemAmount != this.inventory.getAmount(slot)) {
                    this.getLevel().getClient().network.sendPacket((Packet)new ArrowTrapInventoryPacket(this.inventory.getItem((int)slot).item.getID(), this.inventory.getAmount(slot), (ObjectEntity)this));
                }
            } else {
                this.getLevel().getClient().network.sendPacket((Packet)new ArrowTrapInventoryPacket(0, 0, (ObjectEntity)this));
            }
        }
    }

    public boolean shouldRequestPacket() {
        return true;
    }

    public boolean onCooldown() {
        return this.startCooldownTime + this.cooldown > this.getWorldEntity().getTime();
    }

    public void startCooldown() {
        this.startCooldownTime = this.getWorldEntity().getTime();
    }

    public long getTimeSinceActivated() {
        return this.getWorldEntity().getTime() - this.startCooldownTime;
    }

    public void onClientTrigger() {
    }

    public void sendClientTriggerPacket() {
        if (this.isServer()) {
            this.getLevel().getServer().network.sendToClientsWithTile((Packet)new PacketTrapTriggered(this.tileX, this.tileY), this.getLevel(), this.tileX, this.tileY);
        }
    }

    public Point getPos(int x, int y, int dir) {
        if (dir == 0) {
            return new Point(x, y - 1);
        }
        if (dir == 1) {
            return new Point(x + 1, y);
        }
        if (dir == 2) {
            return new Point(x, y + 1);
        }
        return dir == 3 ? new Point(x - 1, y) : new Point(x, y);
    }

    public boolean otherWireActive(int exceptionWireID) {
        for (int i = 0; i < 4; ++i) {
            if (i == exceptionWireID || !this.getLevel().wireManager.isWireActive(this.tileX, this.tileY, i)) continue;
            return true;
        }
        return false;
    }

    public void triggerTrap(int wireID, int dir) {
        if (this.isClient() && this.getClient().hasOpenContainer() && this.getClient().getContainer().form.toString().contains("arrowTrap")) {
            this.getClient().closeContainer(true);
        }
        if (!(this.isClient() || this.onCooldown() || this.otherWireActive(wireID))) {
            Projectile projectile;
            ArrowItem arrow;
            Point position = this.getPos(this.tileX, this.tileY, dir);
            Point targetDir = this.getDir(dir);
            int xPos = position.x * 32;
            if (targetDir.x == 0) {
                xPos += 16;
            } else if (targetDir.x == -1) {
                xPos += 30;
            } else if (targetDir.x == 1) {
                xPos += 2;
            }
            int yPos = position.y * 32;
            if (targetDir.y == 0) {
                yPos += 16;
            } else if (targetDir.y == -1) {
                yPos += 30;
            } else if (targetDir.y == 1) {
                yPos += 2;
            }
            float var10003 = xPos;
            float var10004 = yPos;
            float var10005 = xPos + targetDir.x;
            if (this.itemID == 0) {
                arrow = (ArrowItem)ItemRegistry.getItem((String)"stonearrow");
                projectile = ProjectileRegistry.getProjectile((String)"traparrow");
            } else {
                try {
                    arrow = (ArrowItem)ItemRegistry.getItem((int)this.itemID);
                }
                catch (Exception e) {
                    System.err.println("INVALID ARROW TRAP PROJECTILE USED (mod arrow item). ERROR ITEM: " + ItemRegistry.getItem((int)this.itemID).getStringID());
                    System.err.println("REVERTING TO DEFAULT ARROW");
                    arrow = (ArrowItem)ItemRegistry.getItem((String)"stonearrow");
                }
                try {
                    projectile = ProjectileRegistry.getProjectile((String)arrow.getStringID());
                }
                catch (Exception e) {
                    projectile = ProjectileRegistry.getProjectile((String)"traparrow");
                }
            }
            projectile.x = var10003;
            projectile.y = var10004;
            projectile.setTarget(var10005, (float)(yPos + targetDir.y));
            projectile.speed = 200.0f;
            projectile.distance = 400;
            projectile.setDamage(new GameDamage((float)arrow.damage * 3.5f, (float)(arrow.armorPen * 2 + 10), arrow.critChance + 0.0f, 2.0f, 1.0f));
            projectile.knockback = 10;
            projectile.setOwner(null);
            this.getLevel().entityManager.projectiles.add((Entity)projectile);
            this.startCooldown();
            if (this.itemAmount-- == 0) {
                this.inventory.setItem(0, new InventoryItem(ItemRegistry.getItem((int)0), 0), true);
            } else if (this.itemID == 0 && this.itemAmount <= 0) {
                this.inventory.setItem(0, new InventoryItem(ItemRegistry.getItem((int)0), 0), true);
            } else {
                this.inventory.setItem(0, new InventoryItem(ItemRegistry.getItem((int)this.itemID), this.itemAmount), true);
                this.getLevel().getServer().network.sendToAllClients((Packet)new ArrowTrapInventoryPacket(this.itemID, this.itemAmount, (ObjectEntity)this));
            }
        }
    }

    public Point getDir(int dir) {
        if (dir == 0) {
            return new Point(0, -1);
        }
        if (dir == 1) {
            return new Point(1, 0);
        }
        if (dir == 2) {
            return new Point(0, 1);
        }
        return dir == 3 ? new Point(-1, 0) : new Point();
    }
}

