/*
 * Decompiled with CFR 0.152.
 */
package engineer.objects.logic;

import engineer.Engineer;
import engineer.objects.FakeWallEntity;
import engineer.packets.FakeWallIDPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.level.gameLogicGate.GameLogicGate;
import necesse.level.gameLogicGate.entities.LogicGateEntity;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;

public class WallLogicGateEntity
extends LogicGateEntity {
    public boolean[] wireInputs = new boolean[4];
    private boolean active = false;
    private boolean isRunning;
    private boolean firstTick = true;
    public boolean inverted = false;
    private boolean isRemoved;

    public WallLogicGateEntity(GameLogicGate logicGate, Level level, int tileX, int tileY) {
        super(logicGate, level, tileX, tileY);
    }

    public WallLogicGateEntity(GameLogicGate logicGate, TilePosition pos) {
        this(logicGate, pos.level, pos.tileX, pos.tileY);
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addSmallBooleanArray("wireInputs", this.wireInputs);
        save.addBoolean("inverted", this.inverted);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.wireInputs = save.getSmallBooleanArray("wireInputs", this.wireInputs);
        this.inverted = save.getBoolean("inverted", false);
        this.updateOutputs(true);
    }

    public void writePacket(PacketWriter writer) {
        super.writePacket(writer);
        for (int i = 0; i < 4; ++i) {
            writer.putNextBoolean(this.wireInputs[i]);
        }
        writer.putNextBoolean(this.inverted);
    }

    public void applyPacket(PacketReader reader) {
        super.applyPacket(reader);
        for (int i = 0; i < 4; ++i) {
            this.wireInputs[i] = reader.getNextBoolean();
        }
        this.inverted = reader.getNextBoolean();
        this.updateRunning();
        if (this.isServer()) {
            this.updateOutputs(true);
        }
    }

    public void tick() {
        super.tick();
        if (this.isServer()) {
            this.checkState();
        }
        if (this.firstTick) {
            this.updateRunning();
        }
    }

    protected void onUpdate(int wireID, boolean active) {
        this.updateRunning();
    }

    public void updateRunning() {
        this.isRunning = false;
        for (int i = 0; i < 4; ++i) {
            if (!this.wireInputs[i] || !this.isWireActive(i)) continue;
            this.isRunning = true;
            break;
        }
        if (!this.isRunning) {
            if (this.isServer()) {
                this.checkState();
            }
            this.active = false;
        }
    }

    public boolean conditions() {
        if (this.wireInputs[0] && this.isWireActive(0)) {
            return true;
        }
        if (this.wireInputs[1] && this.isWireActive(1)) {
            return true;
        }
        if (this.wireInputs[2] && this.isWireActive(2)) {
            return true;
        }
        return this.wireInputs[3] && this.isWireActive(3);
    }

    public boolean wallCheck() {
        GameObject wall = this.level.getObject(this.tileX, this.tileY);
        return wall.isWall && !wall.isDoor && !wall.isRock && !wall.isOre && !wall.isFence && !this.level.getObject(this.tileX, this.tileY).getStringID().contains("trap");
    }

    public void checkState() {
        if (!this.inverted) {
            ObjectEntity objectEntity;
            if (this.wallCheck() && !this.level.getObject(this.tileX, this.tileY).getStringID().equalsIgnoreCase("fakewall") && this.conditions()) {
                int wallID = this.level.getObject(this.tileX, this.tileY).getID();
                this.level.setObject(this.tileX, this.tileY, ObjectRegistry.getObject((String)"fakewall").getID());
                this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
                ObjectEntity objectEntity2 = this.level.entityManager.getObjectEntity(this.tileX, this.tileY);
                if (objectEntity2 instanceof FakeWallEntity) {
                    FakeWallEntity wallEnt = (FakeWallEntity)objectEntity2;
                    wallEnt.wallID = wallID;
                    this.getServer().network.sendToAllClients((Packet)new FakeWallIDPacket(wallID, this.tileX, this.tileY, wallEnt));
                    this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
                }
            } else if (this.level.getObject(this.tileX, this.tileY).getStringID().equalsIgnoreCase("fakewall") && !this.conditions() && (objectEntity = this.level.entityManager.getObjectEntity(this.tileX, this.tileY)) instanceof FakeWallEntity) {
                FakeWallEntity wallEnt = (FakeWallEntity)objectEntity;
                this.level.setObject(this.tileX, this.tileY, wallEnt.wallID);
                this.level.entityManager.removeObjectEntity(this.tileX, this.tileY);
                this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
            }
        } else {
            ObjectEntity objectEntity;
            this.level.lightManager.newLight(200.0f);
            if (this.wallCheck() && !this.level.getObject(this.tileX, this.tileY).getStringID().equalsIgnoreCase("fakewall") && !this.conditions()) {
                int wallID = this.level.getObject(this.tileX, this.tileY).getID();
                this.level.setObject(this.tileX, this.tileY, ObjectRegistry.getObject((String)"fakewall").getID());
                this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
                ObjectEntity objectEntity3 = this.level.entityManager.getObjectEntity(this.tileX, this.tileY);
                if (objectEntity3 instanceof FakeWallEntity) {
                    FakeWallEntity wallEnt = (FakeWallEntity)objectEntity3;
                    wallEnt.wallID = wallID;
                    this.getServer().network.sendToAllClients((Packet)new FakeWallIDPacket(wallID, this.tileX, this.tileY, wallEnt));
                    this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
                }
            } else if (this.level.getObject(this.tileX, this.tileY).getStringID().equalsIgnoreCase("fakewall") && this.conditions() && (objectEntity = this.level.entityManager.getObjectEntity(this.tileX, this.tileY)) instanceof FakeWallEntity) {
                FakeWallEntity wallEnt = (FakeWallEntity)objectEntity;
                this.level.setObject(this.tileX, this.tileY, wallEnt.wallID);
                this.level.entityManager.removeObjectEntity(this.tileX, this.tileY);
                this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
            }
        }
    }

    public void remove() {
        this.isRemoved = true;
        ObjectEntity objectEntity = this.level.entityManager.getObjectEntity(this.tileX, this.tileY);
        if (objectEntity instanceof FakeWallEntity) {
            FakeWallEntity wallEnt = (FakeWallEntity)objectEntity;
            this.level.setObject(this.tileX, this.tileY, wallEnt.wallID);
            this.level.entityManager.removeObjectEntity(this.tileX, this.tileY);
            this.level.sendObjectUpdatePacket(this.tileX, this.tileY);
        }
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isActive() {
        return this.active;
    }

    public void updateOutputs(boolean forceUpdate) {
    }

    public void openContainer(ServerClient client) {
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)PacketOpenContainer.LevelObject((int)Engineer.FAKEWALL_LOGIC_GATE_CONTAINER, (int)this.tileX, (int)this.tileY));
    }
}

