/*
 * Decompiled with CFR 0.152.
 */
package engineer.objects.logic;

import engineer.Engineer;
import engineer.packets.UpdateSotrageSizePacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.level.gameLogicGate.GameLogicGate;
import necesse.level.gameLogicGate.entities.LogicGateEntity;
import necesse.level.maps.Level;
import necesse.level.maps.TilePosition;

public class StorageLogicGateEntity
extends LogicGateEntity {
    public boolean[] wireOutputs = new boolean[4];
    private boolean redActive = false;
    private boolean greenActive = false;
    private boolean blueActive = false;
    private boolean yellowActive = false;
    public int foundSlots = this.sizeCheck();
    public int redTrigger = 0;
    public int greenTrigger = 0;
    public int blueTrigger = 0;
    public int yellowTrigger = 0;
    public boolean redInverted = false;
    public boolean greenInverted = false;
    public boolean blueInverted = false;
    public boolean yellowInverted = false;
    private boolean[] outputs;

    public StorageLogicGateEntity(GameLogicGate logicGate, Level level, int tileX, int tileY) {
        super(logicGate, level, tileX, tileY);
    }

    public StorageLogicGateEntity(GameLogicGate logicGate, TilePosition pos) {
        this(logicGate, pos.level, pos.tileX, pos.tileY);
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addSmallBooleanArray("wireOutputs", this.wireOutputs);
        save.addInt("foundSlots", this.foundSlots);
        save.addInt("redTrigger", this.redTrigger);
        save.addInt("greenTrigger", this.greenTrigger);
        save.addInt("blueTrigger", this.blueTrigger);
        save.addInt("yellowTrigger", this.yellowTrigger);
        save.addBoolean("redInverted", this.redInverted);
        save.addBoolean("greenInverted", this.greenInverted);
        save.addBoolean("blueInverted", this.blueInverted);
        save.addBoolean("yellowInverted", this.yellowInverted);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.wireOutputs = save.getSmallBooleanArray("wireOutputs", this.wireOutputs);
        this.foundSlots = save.getInt("foundSlots", 0);
        this.redTrigger = save.getInt("redTrigger", 0);
        this.greenTrigger = save.getInt("greenTrigger", 0);
        this.blueTrigger = save.getInt("blueTrigger", 0);
        this.yellowTrigger = save.getInt("yellowTrigger", 0);
        this.redInverted = save.getBoolean("redInverted", false);
        this.greenInverted = save.getBoolean("greenInverted", false);
        this.blueInverted = save.getBoolean("blueInverted", false);
        this.yellowInverted = save.getBoolean("yellowInverted", false);
        this.updateOutputs(true);
    }

    public void writePacket(PacketWriter writer) {
        super.writePacket(writer);
        for (int i = 0; i < 4; ++i) {
            writer.putNextBoolean(this.wireOutputs[i]);
        }
        writer.putNextInt(this.foundSlots);
        writer.putNextInt(this.redTrigger);
        writer.putNextInt(this.greenTrigger);
        writer.putNextInt(this.blueTrigger);
        writer.putNextInt(this.yellowTrigger);
        writer.putNextBoolean(this.redInverted);
        writer.putNextBoolean(this.greenInverted);
        writer.putNextBoolean(this.blueInverted);
        writer.putNextBoolean(this.yellowInverted);
    }

    public void applyPacket(PacketReader reader) {
        super.applyPacket(reader);
        for (int i = 0; i < 4; ++i) {
            this.wireOutputs[i] = reader.getNextBoolean();
        }
        this.foundSlots = reader.getNextInt();
        this.redTrigger = reader.getNextInt();
        this.greenTrigger = reader.getNextInt();
        this.blueTrigger = reader.getNextInt();
        this.yellowTrigger = reader.getNextInt();
        this.redInverted = reader.getNextBoolean();
        this.greenInverted = reader.getNextBoolean();
        this.blueInverted = reader.getNextBoolean();
        this.yellowInverted = reader.getNextBoolean();
    }

    public void tick() {
        super.tick();
        if (this.isServer()) {
            this.fillCheck();
            if (this.sizeCheck() != this.foundSlots) {
                this.getServer().network.sendToAllClients((Packet)new UpdateSotrageSizePacket(this.foundSlots, this.sizeCheck(), this.tileX, this.tileY));
                this.foundSlots = this.sizeCheck();
            }
        }
    }

    private int sizeCheck() {
        InventoryObjectEntity invObjectEntity;
        try {
            invObjectEntity = (InventoryObjectEntity)this.level.entityManager.getObjectEntity(this.tileX, this.tileY);
        }
        catch (Exception e) {
            invObjectEntity = null;
        }
        if (invObjectEntity != null) {
            return invObjectEntity.inventory.getSize();
        }
        return 0;
    }

    private void fillCheck() {
        InventoryObjectEntity invObjectEntity;
        try {
            invObjectEntity = (InventoryObjectEntity)this.level.entityManager.getObjectEntity(this.tileX, this.tileY);
        }
        catch (Exception e) {
            invObjectEntity = null;
        }
        if (invObjectEntity != null) {
            int slots = invObjectEntity.inventory.getSize();
            int filled = 0;
            for (int i = 0; i <= slots; ++i) {
                if (invObjectEntity.inventory.isSlotClear(i)) continue;
                ++filled;
            }
            this.redActive = filled >= this.redTrigger && !this.redInverted || filled < this.redTrigger && this.redInverted;
            this.greenActive = filled >= this.greenTrigger && !this.greenInverted || filled < this.greenTrigger && this.greenInverted;
            this.blueActive = filled >= this.blueTrigger && !this.blueInverted || filled < this.blueTrigger && this.blueInverted;
            this.yellowActive = filled >= this.yellowTrigger && !this.yellowInverted || filled < this.yellowTrigger && this.yellowInverted;
            this.updateOutputs(true);
        }
    }

    public void updateOutputs(boolean forceUpdate) {
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                this.setOutput(i, this.redActive, forceUpdate);
                continue;
            }
            if (i == 1) {
                this.setOutput(i, this.greenActive, forceUpdate);
                continue;
            }
            if (i == 2) {
                this.setOutput(i, this.blueActive, forceUpdate);
                continue;
            }
            if (i != 3) continue;
            this.setOutput(i, this.yellowActive, forceUpdate);
        }
    }

    public ListGameTooltips getTooltips(PlayerMob perspective, boolean debug) {
        ListGameTooltips tooltips = super.getTooltips(perspective, debug);
        return tooltips;
    }

    public String addAzero(Integer time) {
        String out = time < 10 ? "0" + Integer.toString(time) : Integer.toString(time);
        return out;
    }

    public void openContainer(ServerClient client) {
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)PacketOpenContainer.LevelObject((int)Engineer.STORAGE_LOGIC_GATE_CONTAINER, (int)this.tileX, (int)this.tileY));
    }
}

